/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OBinaryCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OBinaryCompareOperator operator;
    protected OExpression right;

    public OBinaryCondition(int id) {
        super(id);
    }

    public OBinaryCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        return this.operator.execute(this.left.execute(currentRecord, ctx), this.right.execute(currentRecord, ctx));
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" ");
        builder.append(this.operator.toString());
        builder.append(" ");
        this.right.toString(params, builder);
    }

    @Override
    protected boolean supportsBasicCalculation() {
        if (!this.operator.supportsBasicCalculation()) {
            return false;
        }
        return this.left.supportsBasicCalculation() && this.right.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (!this.operator.supportsBasicCalculation()) {
            ++total;
        }
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (!this.right.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!this.operator.supportsBasicCalculation()) {
            result.add(this);
        }
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (!this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        return result;
    }

    public OBinaryCondition isIndexedFunctionCondition(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.left.isIndexedFunctionCal()) {
            return this;
        }
        return null;
    }

    public long estimateIndexed(OFromClause target, OCommandContext context) {
        return this.left.estimateIndexedFunction(target, context, this.operator, this.right.execute(null, context));
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context) {
        return this.left.executeIndexedFunction(target, context, this.operator, this.right.execute(null, context));
    }

    @Override
    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.left.isIndexedFunctionCal()) {
            return Collections.singletonList(this);
        }
        return null;
    }
}

