/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.cassandradriver.Cassandra;
import org.wildfly.swarm.config.cassandradriver.CassandraConsumer;
import org.wildfly.swarm.config.cassandradriver.CassandraSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=cassandradriver")
@ResourceType(value="subsystem")
@Implicit
public class Cassandradriver<T extends Cassandradriver<T>>
extends HashMap
implements Keyed {
    private String key = "cassandradriver";
    private PropertyChangeSupport pcs;
    private CassandradriverResources subresources = new CassandradriverResources();

    public Cassandradriver() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public CassandradriverResources subresources() {
        return this.subresources;
    }

    public T cassandras(List<Cassandra> value) {
        this.subresources.cassandras = value;
        return (T)this;
    }

    public T cassandra(Cassandra value) {
        this.subresources.cassandras.add(value);
        return (T)this;
    }

    public T cassandra(String childKey, CassandraConsumer consumer) {
        Cassandra child = new Cassandra(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.cassandra(child);
        return (T)this;
    }

    public T cassandra(String childKey) {
        this.cassandra(childKey, null);
        return (T)this;
    }

    public T cassandra(CassandraSupplier supplier) {
        this.cassandra(supplier.get());
        return (T)this;
    }

    public static class CassandradriverResources {
        @ResourceDocumentation(value="Cassandra server definition")
        @SubresourceInfo(value="cassandra")
        private List<Cassandra> cassandras = new ArrayList<Cassandra>();

        @Subresource
        public List<Cassandra> cassandras() {
            return this.cassandras;
        }

        public Cassandra cassandra(String key) {
            return this.cassandras.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

