/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import java.util.ArrayList;
import java.util.Collection;

public class OCommandSQLPojoWrapper
implements OCommandRequest {
    private OCommandRequest command;
    private ODatabasePojoAbstract<?> database;

    public OCommandSQLPojoWrapper(ODatabasePojoAbstract<?> iDatabase, OCommandRequest iCommand) {
        this.database = iDatabase;
        this.command = iCommand;
    }

    public <RET> RET execute(Object ... iArgs) {
        this.database.convertParameters(iArgs);
        ArrayList<Object> result = this.command.execute(iArgs);
        if (result instanceof Collection) {
            ArrayList<ODocument> resultPojo = new ArrayList<ODocument>();
            Collection coll = result;
            for (ODocument doc : coll) {
                Object obj = doc.getClassName() == null ? doc : this.database.getUserObjectByRecord((OIdentifiable)doc, this.getFetchPlan(), true);
                resultPojo.add((ODocument)obj);
            }
            result = resultPojo;
        } else if (result instanceof ODocument && ((ODocument)result).getClassName() != null) {
            result = this.database.getUserObjectByRecord((OIdentifiable)((ODocument)result), this.getFetchPlan(), true);
        }
        return (RET)result;
    }

    public int getLimit() {
        return this.command.getLimit();
    }

    public OCommandRequest setLimit(int iLimit) {
        this.command.setLimit(iLimit);
        return this;
    }

    public boolean isIdempotent() {
        return this.command.isIdempotent();
    }

    public String getFetchPlan() {
        return this.command.getFetchPlan();
    }

    public <RET extends OCommandRequest> RET setFetchPlan(String iFetchPlan) {
        this.command.setFetchPlan(iFetchPlan);
        return null;
    }

    public void setUseCache(boolean iUseCache) {
        this.command.setUseCache(iUseCache);
    }

    public OCommandContext getContext() {
        return this.command.getContext();
    }

    public OCommandRequest setContext(OCommandContext iContext) {
        this.command.setContext(iContext);
        return this;
    }

    public long getTimeoutTime() {
        return this.command.getTimeoutTime();
    }

    public OCommandContext.TIMEOUT_STRATEGY getTimeoutStrategy() {
        return this.command.getTimeoutStrategy();
    }

    public void setTimeout(long timeout, OCommandContext.TIMEOUT_STRATEGY strategy) {
        this.command.setTimeout(timeout, strategy);
    }
}

