/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;
import org.wildfly.swarm.spi.runtime.ConfigurationMarshaller;

@ApplicationScoped
public class ExtensionMarshaller
implements ConfigurationMarshaller {
    @Inject
    @Any
    private Instance<Fraction> fractions;

    public void marshal(List<ModelNode> list) {
        ArrayList<ModelNode> extensions = new ArrayList<ModelNode>();
        HashSet<String> seen = new HashSet<String>();
        for (Fraction each : this.fractions) {
            String module;
            WildFlyExtension anno = each.getClass().getAnnotation(WildFlyExtension.class);
            if (anno == null || anno.module() == null || anno.module().equals("") || seen.contains(module = anno.module())) continue;
            ModelNode node = new ModelNode();
            node.get("address").set("extension", anno.module());
            node.get("operation").set("add");
            extensions.add(node);
            seen.add(module);
        }
        list.addAll(0, extensions);
    }
}

