/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.OUncompletedCommit;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCacheHook;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSessionMetadata;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OClassTrigger;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.ORidBagDeleter;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OTransactionBlockedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.ClassIndexManagerRemote;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.function.OFunctionTrigger;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORestrictedAccessHook;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityTrackerHook;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.OUserTrigger;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceTrigger;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.schedule.OSchedulerTrigger;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSaveThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class ODatabaseDocumentTx
extends OListenerManger<ODatabaseListener>
implements ODatabaseDocumentInternal {
    @Deprecated
    private static final String DEF_RECORD_FORMAT = "csv";
    protected static ORecordSerializer defaultSerializer = ORecordSerializerFactory.instance().getFormat(OGlobalConfiguration.DB_DOCUMENT_SERIALIZER.getValueAsString());
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<ORecordHook, ORecordHook.HOOK_POSITION> unmodifiableHooks;
    private final Set<OIdentifiable> inHook = new HashSet<OIdentifiable>();
    protected ORecordSerializer serializer;
    private String url;
    private OStorage storage;
    private ODatabase.STATUS status;
    private OIntent currentIntent;
    private ODatabaseInternal<?> databaseOwner;
    private OMetadataDefault metadata;
    private OImmutableUser user;
    private byte recordType;
    @Deprecated
    private String recordFormat;
    private final Map<ORecordHook, ORecordHook.HOOK_POSITION> hooks = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>();
    private boolean retainRecords = true;
    private OLocalRecordCache localCache;
    private boolean mvcc;
    private OCurrentStorageComponentsFactory componentsFactory;
    private boolean initialized = false;
    private OTransaction currentTx;
    private boolean keepStorageOpen = false;
    private final AtomicReference<Thread> owner = new AtomicReference();
    protected ODatabaseSessionMetadata sessionMetadata;

    public ODatabaseDocumentTx(String iURL) {
        this(iURL, false);
    }

    public ODatabaseDocumentTx(String iURL, boolean keepStorageOpen) {
        super(false);
        if (iURL == null) {
            throw new IllegalArgumentException("URL parameter is null");
        }
        this.activateOnCurrentThread();
        try {
            this.keepStorageOpen = keepStorageOpen;
            this.url = iURL.replace('\\', '/');
            this.status = ODatabase.STATUS.CLOSED;
            this.setProperty("fetch-max", 50);
            this.storage = Orient.instance().loadStorage(this.url);
            this.url = this.storage.getURL();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.recordType = (byte)100;
            this.localCache = new OLocalRecordCache();
            this.mvcc = OGlobalConfiguration.DB_MVCC.getValueAsBoolean();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            if (this.storage != null) {
                Orient.instance().unregisterStorage(this.storage);
            }
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            throw OException.wrapException(new ODatabaseException("Error on opening database '" + iURL + "'"), t);
        }
        this.setSerializer(defaultSerializer);
    }

    public static ORecordSerializer getDefaultSerializer() {
        return defaultSerializer;
    }

    public static void setDefaultSerializer(ORecordSerializer iDefaultSerializer) {
        defaultSerializer = iDefaultSerializer;
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        boolean failure = true;
        this.setupThreadOwner();
        this.activateOnCurrentThread();
        try {
            String name;
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.user != null && !this.user.getName().equals(iUserName)) {
                this.initialized = false;
            }
            String encKey = (String)this.getProperty(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey());
            String currKey = null;
            if (this.storage.getConfiguration() != null && this.storage.getConfiguration().getContextConfiguration() != null) {
                currKey = (String)this.storage.getConfiguration().getContextConfiguration().getValue(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
                if (encKey != null && currKey != null && !encKey.equals(currKey) && !this.storage.isClosed()) {
                    this.storage.close(true, false);
                }
            }
            if (this.storage.isClosed()) {
                this.storage.open(iUserName, iUserPassword, this.properties);
                this.initialized = false;
            } else if (this.storage instanceof OStorageProxy && ((name = ((OStorageProxy)this.storage).getUserName()) == null || !name.equals(iUserName))) {
                this.storage.close();
                this.storage.open(iUserName, iUserPassword, this.properties);
            }
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen(iUserName, iUserPassword);
            if (!(this.getStorage() instanceof OStorageProxy)) {
                OSecurity security = this.metadata.getSecurity();
                if (this.user == null || this.user.getVersion() != security.getVersion() || !this.user.getName().equalsIgnoreCase(iUserName)) {
                    OUser usr = this.metadata.getSecurity().authenticate(iUserName, iUserPassword);
                    this.user = usr != null ? new OImmutableUser(security.getVersion(), usr) : null;
                    this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_READ, new Object[0]);
                }
            }
            this.callOnOpenListeners();
            failure = false;
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw OException.wrapException(new ODatabaseException("Cannot open database url=" + this.getURL()), e);
        }
        finally {
            if (failure) {
                this.owner.set(null);
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB open(OToken iToken) {
        boolean failure = true;
        this.setupThreadOwner();
        this.activateOnCurrentThread();
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.user != null && !this.user.getIdentity().equals(iToken.getUserId())) {
                this.initialized = false;
            }
            if (this.storage instanceof OStorageProxy) {
                throw new ODatabaseException("Cannot use a token open on remote database");
            }
            if (this.storage.isClosed()) {
                this.storage.open("", "", this.properties);
            }
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen(null, null);
            OSecurity security = this.metadata.getSecurity();
            if (this.user == null || this.user.getVersion() != security.getVersion()) {
                OUser usr = this.metadata.getSecurity().authenticate(iToken);
                this.user = usr != null ? new OImmutableUser(security.getVersion(), usr) : null;
                this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_READ, new Object[0]);
            }
            this.callOnOpenListeners();
            failure = false;
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw OException.wrapException(new ODatabaseException("Cannot open database"), e);
        }
        finally {
            if (failure) {
                this.owner.set(null);
            }
        }
        return (DB)this;
    }

    private void setupThreadOwner() {
        Thread current = Thread.currentThread();
        Thread o = this.owner.get();
        if (o != null || !this.owner.compareAndSet(null, current)) {
            throw new IllegalStateException("Current instance is owned by other thread" + (o != null ? " : '" + o.getName() + "'" : ""));
        }
    }

    public void callOnOpenListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onOpen(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                listener.onOpen(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public <DB extends ODatabase> DB create() {
        return this.create((Map<OGlobalConfiguration, Object>)null);
    }

    @Override
    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        this.create();
        OStorage storage = this.getStorage();
        storage.restoreFromIncrementalBackup(incrementalBackupPath);
        this.metadata = new OMetadataDefault(this);
        this.metadata.load();
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        this.setupThreadOwner();
        this.activateOnCurrentThread();
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            OContextConfiguration ctxCfg = this.storage.getConfiguration().getContextConfiguration();
            if (iInitialSettings != null && !iInitialSettings.isEmpty()) {
                for (Map.Entry<OGlobalConfiguration, Object> e : iInitialSettings.entrySet()) {
                    ctxCfg.setValue(e.getKey(), e.getValue());
                }
                this.storage.getConfiguration().update();
            }
            this.storage.create(this.properties);
            this.status = ODatabase.STATUS.OPEN;
            this.componentsFactory = this.getStorage().getComponentsFactory();
            this.localCache.startup();
            this.getStorage().getConfiguration().setRecordSerializer(this.getSerializer().toString());
            this.getStorage().getConfiguration().setRecordSerializerVersion(this.getSerializer().getCurrentVersion());
            this.getStorage().getConfiguration().setProperty("strictSql", "true");
            this.getStorage().getConfiguration().update();
            if (!(this.getStorage() instanceof OStorageProxy)) {
                this.installHooksEmbedded();
            }
            this.metadata = new OMetadataDefault(this);
            this.metadata.create();
            if (!(this.getStorage() instanceof OStorageProxy)) {
                this.registerHook(new OCommandCacheHook(this), ORecordHook.HOOK_POSITION.REGULAR);
            }
            this.registerHook(new OSecurityTrackerHook(this.metadata.getSecurity(), this), ORecordHook.HOOK_POSITION.LAST);
            OUser usr = this.getMetadata().getSecurity().getUser("admin");
            this.user = usr == null ? null : new OImmutableUser(this.getMetadata().getSecurity().getVersion(), usr);
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreate(this.getDatabaseOwner());
            }
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onCreate(this);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot create database '" + this.getName() + "'"), e);
        }
        return (DB)this;
    }

    @Override
    public void drop() {
        this.checkOpeness();
        this.checkIfActive();
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_DELETE, new Object[0]);
        this.callOnDropListeners();
        if (this.metadata != null) {
            this.metadata.close();
            this.metadata = null;
        }
        this.closeOnDelete();
        try {
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.delete();
            this.storage = null;
            this.status = ODatabase.STATUS.CLOSED;
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            this.clearOwner();
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot delete database"), e);
        }
    }

    public ODatabaseDocumentTx copy() {
        ODatabaseDocumentInternal dbInThreadLocal = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (this.isClosed()) {
            throw new ODatabaseException("Cannot copy a closed db");
        }
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(this.url);
        db.setupThreadOwner();
        db.user = this.user;
        db.properties.putAll(this.properties);
        db.serializer = this.serializer;
        db.componentsFactory = this.componentsFactory;
        db.metadata = new OMetadataDefault(db);
        db.initialized = true;
        if (this.storage instanceof OStorageProxy) {
            db.storage = ((OStorageProxy)this.storage).copy(this, db);
            ((OStorageProxy)db.storage).addUser();
        } else {
            db.storage = this.storage;
        }
        db.setStatus(ODatabase.STATUS.OPEN);
        db.metadata.load();
        if (!(db.getStorage() instanceof OStorageProxy)) {
            db.installHooksEmbedded();
        } else {
            db.installHooksRemote();
        }
        db.initialized = true;
        if (dbInThreadLocal != null) {
            dbInThreadLocal.activateOnCurrentThread();
        } else if (ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            ODatabaseRecordThreadLocal.INSTANCE.remove();
        }
        return db;
    }

    public void callOnCloseListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onClose(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                listener.onClose(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void callOnDropListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            this.activateOnCurrentThread();
            it.next().onDrop(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                this.activateOnCurrentThread();
                listener.onDelete(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public <RET extends ORecord> RET getRecord(OIdentifiable iIdentifiable) {
        if (iIdentifiable instanceof ORecord) {
            return (RET)((ORecord)iIdentifiable);
        }
        return (RET)this.load(iIdentifiable.getIdentity());
    }

    @Override
    public void reload() {
        this.checkIfActive();
        if (this.isClosed()) {
            throw new ODatabaseException("Cannot reload a closed db");
        }
        this.metadata.reload();
        this.storage.reload();
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecordId, null, -1, iFetchPlan, iIgnoreCache, !iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT, new SimpleRecordReader());
    }

    @Override
    public ODatabase<ORecord> delete(ORID iRecord, int iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, ODatabase.OPERATION_MODE.SYNCHRONOUS, false);
        return this;
    }

    @Override
    public ODatabase<ORecord> cleanOutRecord(ORID iRecord, int iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, ODatabase.OPERATION_MODE.SYNCHRONOUS, true);
        return this;
    }

    @Override
    public String getType() {
        return "document";
    }

    public ODatabaseDocument delete(ORID iRecord, ODatabase.OPERATION_MODE iMode) {
        Object record = iRecord.getRecord();
        if (record == null) {
            return this;
        }
        this.delete((ORecord)record, iMode);
        return this;
    }

    public ODatabaseDocument delete(ORecord iRecord, ODatabase.OPERATION_MODE iMode) {
        this.checkIfActive();
        this.currentTx.deleteRecord(iRecord, iMode);
        return this;
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iClass) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId);
    }

    @Override
    @Deprecated
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId, startClusterPosition, endClusterPosition);
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.checkSecurity(ORule.ResourceGeneric.COMMAND, ORole.PERMISSION_READ, new Object[0]);
        this.checkIfActive();
        OCommandRequestInternal command = (OCommandRequestInternal)iCommand;
        try {
            command.reset();
            return command;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Error on command execution"), e);
        }
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.checkIfActive();
        iCommand.reset();
        return (RET)((List)iCommand.execute(iArgs));
    }

    @Override
    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        return this.countClusterElements(iClusterIds, false);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        return this.countClusterElements(iClusterId, false);
    }

    @Override
    public void truncateCluster(String clusterName) {
        this.command(new OCommandSQL("truncate cluster " + clusterName)).execute(new Object[0]);
    }

    @Override
    public long countClusterElements(int iClusterId, boolean countTombstones) {
        String name = this.getClusterNameById(iClusterId);
        if (name == null) {
            return 0L;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)name);
        this.checkIfActive();
        return this.storage.count(iClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        this.checkIfActive();
        for (int iClusterId : iClusterIds) {
            String name = this.getClusterNameById(iClusterId);
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)name);
        }
        return this.storage.count(iClusterIds, countTombstones);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        if (clusterId < 0) {
            throw new IllegalArgumentException("Cluster '" + iClusterName + "' was not found");
        }
        return this.storage.count(clusterId);
    }

    @Override
    public OMetadataDefault getMetadata() {
        this.checkOpeness();
        return this.metadata;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(resourceGeneric, resourceSpecific, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "User '%s' tried to access the reserved resource '%s.%s', operation '%s'", this.getUser(), resourceGeneric, resourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (this.user != null) {
            try {
                if (iResourcesSpecific.length != 0) {
                    for (Object target : iResourcesSpecific) {
                        if (target != null) {
                            this.user.allow(iResourceGeneric, target.toString(), iOperation);
                            continue;
                        }
                        this.user.allow(iResourceGeneric, null, iOperation);
                    }
                } else {
                    this.user.allow(iResourceGeneric, null, iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access the reserved resource '%s', target(s) '%s', operation '%s'", this.getUser(), iResourceGeneric, Arrays.toString(iResourcesSpecific), iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object iResourceSpecific) {
        this.checkOpeness();
        if (this.user != null) {
            try {
                if (iResourceSpecific != null) {
                    this.user.allow(iResourceGeneric, iResourceSpecific.toString(), iOperation);
                } else {
                    this.user.allow(iResourceGeneric, null, iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access the reserved resource '%s', target '%s', operation '%s'", this.getUser(), iResourceGeneric, iResourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public ODatabaseInternal<?> getDatabaseOwner() {
        ODatabaseInternal<?> current;
        for (current = this.databaseOwner; current != null && current != this && current.getDatabaseOwner() != current; current = current.getDatabaseOwner()) {
        }
        return current;
    }

    @Override
    public ODatabaseInternal<ORecord> setDatabaseOwner(ODatabaseInternal<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public boolean isRetainRecords() {
        return this.retainRecords;
    }

    @Override
    public ODatabaseDocument setRetainRecords(boolean retainRecords) {
        this.retainRecords = retainRecords;
        return this;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        this.checkIfActive();
        this.setStatusInternal(status);
        return (DB)this;
    }

    public void setStatusInternal(ODatabase.STATUS status) {
        this.status = status;
    }

    @Deprecated
    public void setDefaultClusterIdInternal(int iDefClusterId) {
        this.checkIfActive();
        this.getStorage().setDefaultClusterId(iDefClusterId);
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        this.set(iAttribute, iValue);
    }

    @Override
    public OSecurityUser getUser() {
        return this.user;
    }

    @Override
    public void setUser(OSecurityUser user) {
        this.checkIfActive();
        if (user instanceof OUser) {
            OMetadataDefault metadata = this.getMetadata();
            if (metadata != null) {
                OSecurity security = metadata.getSecurity();
                this.user = new OImmutableUser(security.getVersion(), (OUser)user);
            } else {
                this.user = new OImmutableUser(-1L, (OUser)user);
            }
        } else {
            this.user = (OImmutableUser)user;
        }
    }

    @Override
    public void reloadUser() {
        if (this.user != null) {
            OSecurity security;
            OUser secGetUser;
            this.activateOnCurrentThread();
            OMetadataDefault metadata = this.getMetadata();
            this.user = metadata != null ? ((secGetUser = (security = metadata.getSecurity()).getUser(this.user.getName())) != null ? new OImmutableUser(security.getVersion(), secGetUser) : new OImmutableUser(-1L, new OUser())) : new OImmutableUser(-1L, new OUser());
        }
    }

    @Override
    public boolean isMVCC() {
        return this.mvcc;
    }

    @Override
    public <DB extends ODatabase<?>> DB setMVCC(boolean mvcc) {
        this.mvcc = mvcc;
        return (DB)this;
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        this.checkOpeness();
        return this.metadata.getIndexManager().getDictionary();
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        this.checkOpeness();
        this.checkIfActive();
        LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION> tmp = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>(this.hooks);
        tmp.put(iHookImpl, iPosition);
        this.hooks.clear();
        for (ORecordHook.HOOK_POSITION p : ORecordHook.HOOK_POSITION.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.hooks.put((ORecordHook)e.getKey(), (ORecordHook.HOOK_POSITION)((Object)e.getValue()));
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl) {
        return this.registerHook(iHookImpl, ORecordHook.HOOK_POSITION.REGULAR);
    }

    @Override
    public <DB extends ODatabase<?>> DB unregisterHook(ORecordHook iHookImpl) {
        this.checkIfActive();
        if (iHookImpl != null) {
            iHookImpl.onUnregister();
            this.hooks.remove(iHookImpl);
        }
        return (DB)this;
    }

    @Override
    public OLocalRecordCache getLocalCache() {
        return this.localCache;
    }

    @Override
    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        return this.unmodifiableHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE type, OIdentifiable id) {
        if (id == null || this.hooks.isEmpty() || id.getIdentity().getClusterId() == 0) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        ORID identity = id.getIdentity().copy();
        if (!this.pushInHook(identity)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        try {
            Object rec = id.getRecord();
            if (rec == null) {
                ORecordHook.RESULT rESULT = ORecordHook.RESULT.RECORD_NOT_CHANGED;
                return rESULT;
            }
            OScenarioThreadLocal.RUN_MODE runMode = OScenarioThreadLocal.INSTANCE.getRunMode();
            boolean recordChanged = false;
            block11: for (ORecordHook hook : this.hooks.keySet()) {
                switch (runMode) {
                    case DEFAULT: {
                        if (!this.getStorage().isDistributed() || hook.getDistributedExecutionMode() != ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE) break;
                        continue block11;
                    }
                    case RUNNING_DISTRIBUTED: {
                        if (hook.getDistributedExecutionMode() != ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE) break;
                        continue block11;
                    }
                }
                ORecordHook.RESULT res = hook.onTrigger(type, (ORecord)rec);
                if (res == ORecordHook.RESULT.RECORD_CHANGED) {
                    recordChanged = true;
                    continue;
                }
                if (res == ORecordHook.RESULT.SKIP_IO) {
                    ORecordHook.RESULT rESULT = res;
                    return rESULT;
                }
                if (res == ORecordHook.RESULT.SKIP) {
                    ORecordHook.RESULT rESULT = res;
                    return rESULT;
                }
                if (res != ORecordHook.RESULT.RECORD_REPLACED) continue;
                ORecordHook.RESULT rESULT = res;
                return rESULT;
            }
            Object object = recordChanged ? ORecordHook.RESULT.RECORD_CHANGED : ORecordHook.RESULT.RECORD_NOT_CHANGED;
            return object;
        }
        finally {
            this.popInHook(identity);
        }
    }

    @Override
    public boolean isValidationEnabled() {
        return (Boolean)this.get(ODatabase.ATTRIBUTES.VALIDATION);
    }

    @Override
    public <DB extends ODatabaseDocument> DB setValidationEnabled(boolean iEnabled) {
        this.set(ODatabase.ATTRIBUTES.VALIDATION, iEnabled);
        return (DB)this;
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        this.checkIfActive();
        return this.getStorage().getConflictStrategy();
    }

    @Override
    public ODatabaseDocumentTx setConflictStrategy(String iStrategyName) {
        this.checkIfActive();
        this.getStorage().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public ODatabaseDocumentTx setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.checkIfActive();
        this.getStorage().setConflictStrategy(iResolver);
        return this;
    }

    @Override
    public OContextConfiguration getConfiguration() {
        this.checkIfActive();
        if (this.storage != null) {
            return this.storage.getConfiguration().getContextConfiguration();
        }
        return null;
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        this.checkIfActive();
        if (this.currentIntent != null) {
            if (iIntent != null && iIntent.getClass().equals(this.currentIntent.getClass())) {
                return false;
            }
            this.currentIntent.end(this);
        }
        this.currentIntent = iIntent;
        if (iIntent != null) {
            iIntent.begin(this);
        }
        return true;
    }

    @Override
    public boolean exists() {
        if (this.status == ODatabase.STATUS.OPEN) {
            return true;
        }
        if (this.storage == null) {
            this.storage = Orient.instance().loadStorage(this.url);
        }
        return this.storage.exists();
    }

    @Override
    public void close() {
        this.checkIfActive();
        try {
            this.localCache.shutdown();
            if (this.isClosed()) {
                this.status = ODatabase.STATUS.CLOSED;
                return;
            }
            try {
                this.commit(true);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Exception during commit of active transaction", e, new Object[0]);
            }
            if (this.status != ODatabase.STATUS.OPEN) {
                return;
            }
            this.callOnCloseListeners();
            if (this.currentIntent != null) {
                this.currentIntent.end(this);
                this.currentIntent = null;
            }
            this.status = ODatabase.STATUS.CLOSED;
            this.localCache.clear();
            if (!this.keepStorageOpen && this.storage != null) {
                this.storage.close();
            }
        }
        finally {
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            this.clearOwner();
        }
    }

    private void clearOwner() {
        this.owner.set(null);
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.status;
    }

    @Override
    public long getSize() {
        this.checkIfActive();
        return this.storage.getSize();
    }

    @Override
    public String getName() {
        return this.storage != null ? this.storage.getName() : this.url;
    }

    @Override
    public String getURL() {
        return this.url != null ? this.url : this.storage.getURL();
    }

    @Override
    public int getDefaultClusterId() {
        this.checkIfActive();
        return this.storage.getDefaultClusterId();
    }

    @Override
    public int getClusters() {
        this.checkIfActive();
        return this.storage.getClusters();
    }

    @Override
    public boolean existsCluster(String iClusterName) {
        this.checkIfActive();
        return this.storage.getClusterNames().contains(iClusterName.toLowerCase());
    }

    @Override
    public Collection<String> getClusterNames() {
        this.checkIfActive();
        return this.storage.getClusterNames();
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        if (iClusterName == null) {
            return -1;
        }
        this.checkIfActive();
        return this.storage.getClusterIdByName(iClusterName.toLowerCase());
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        if (iClusterId == -1) {
            return null;
        }
        this.checkIfActive();
        return this.storage.getPhysicalClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeByName(String clusterName) {
        this.checkIfActive();
        try {
            return this.storage.getClusterById(this.getClusterIdByName(clusterName)).getRecordsSize();
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Error on reading records size for cluster '" + clusterName + "'"), e);
        }
    }

    @Override
    public long getClusterRecordSizeById(int clusterId) {
        this.checkIfActive();
        try {
            return this.storage.getClusterById(clusterId).getRecordsSize();
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Error on reading records size for cluster with id '" + clusterId + "'"), e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.status == ODatabase.STATUS.CLOSED || this.storage.isClosed();
    }

    @Override
    public int addCluster(String iClusterName, Object ... iParameters) {
        this.checkIfActive();
        return this.storage.addCluster(iClusterName, false, iParameters);
    }

    @Override
    public int addCluster(String iClusterName, int iRequestedId, Object ... iParameters) {
        this.checkIfActive();
        return this.storage.addCluster(iClusterName, iRequestedId, false, iParameters);
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        OSchemaProxy schema = this.metadata.getSchema();
        OClass clazz = schema.getClassByClusterId(clusterId);
        if (clazz != null) {
            clazz.removeClusterId(clusterId);
        }
        if (schema.getBlobClusters().contains(clusterId)) {
            schema.removeBlobCluster(iClusterName);
        }
        this.getLocalCache().freeCluster(clusterId);
        return this.storage.dropCluster(iClusterName, iTruncate);
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.checkIfActive();
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(iClusterId));
        OSchemaProxy schema = this.metadata.getSchema();
        OClass clazz = schema.getClassByClusterId(iClusterId);
        if (clazz != null) {
            clazz.removeClusterId(iClusterId);
        }
        this.getLocalCache().freeCluster(iClusterId);
        if (schema.getBlobClusters().contains(iClusterId)) {
            schema.removeBlobCluster(this.getClusterNameById(iClusterId));
        }
        return this.storage.dropCluster(iClusterId, iTruncate);
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        if (iValue == null) {
            return this.properties.remove(iName.toLowerCase());
        }
        return this.properties.put(iName.toLowerCase(), iValue);
    }

    @Override
    public Object getProperty(String iName) {
        return this.properties.get(iName.toLowerCase());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet().iterator();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        this.checkIfActive();
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case STATUS: {
                return this.getStatus();
            }
            case DEFAULTCLUSTERID: {
                return this.getDefaultClusterId();
            }
            case TYPE: {
                return this.getMetadata().getImmutableSchemaSnapshot().existsClass("V") ? "graph" : "document";
            }
            case DATEFORMAT: {
                return this.storage.getConfiguration().dateFormat;
            }
            case DATETIMEFORMAT: {
                return this.storage.getConfiguration().dateTimeFormat;
            }
            case TIMEZONE: {
                return this.storage.getConfiguration().getTimeZone().getID();
            }
            case LOCALECOUNTRY: {
                return this.storage.getConfiguration().getLocaleCountry();
            }
            case LOCALELANGUAGE: {
                return this.storage.getConfiguration().getLocaleLanguage();
            }
            case CHARSET: {
                return this.storage.getConfiguration().getCharset();
            }
            case CUSTOM: {
                return this.storage.getConfiguration().getProperties();
            }
            case CLUSTERSELECTION: {
                return this.storage.getConfiguration().getClusterSelection();
            }
            case MINIMUMCLUSTERS: {
                return this.storage.getConfiguration().getMinimumClusters();
            }
            case CONFLICTSTRATEGY: {
                return this.storage.getConfiguration().getConflictStrategy();
            }
            case VALIDATION: {
                return this.storage.getConfiguration().isValidationEnabled();
            }
        }
        return null;
    }

    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        this.checkIfActive();
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = OIOUtils.getStringContent(iValue != null ? iValue.toString() : null);
        switch (iAttribute) {
            case STATUS: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("DB status can't be null");
                }
                this.setStatus(ODatabase.STATUS.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case DEFAULTCLUSTERID: {
                if (iValue == null) break;
                if (iValue instanceof Number) {
                    this.storage.setDefaultClusterId(((Number)iValue).intValue());
                    break;
                }
                this.storage.setDefaultClusterId(this.storage.getClusterIdByName(iValue.toString()));
                break;
            }
            case TYPE: {
                throw new IllegalArgumentException("Database type cannot be changed at run-time");
            }
            case DATEFORMAT: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("date format is null");
                }
                new SimpleDateFormat(stringValue).format(new Date());
                this.storage.getConfiguration().dateFormat = stringValue;
                this.storage.getConfiguration().update();
                break;
            }
            case DATETIMEFORMAT: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("date format is null");
                }
                new SimpleDateFormat(stringValue).format(new Date());
                this.storage.getConfiguration().dateTimeFormat = stringValue;
                this.storage.getConfiguration().update();
                break;
            }
            case TIMEZONE: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("Timezone can't be null");
                }
                TimeZone timeZoneValue = TimeZone.getTimeZone(stringValue.toUpperCase());
                if (timeZoneValue.equals(TimeZone.getTimeZone("GMT"))) {
                    timeZoneValue = TimeZone.getTimeZone(stringValue);
                }
                this.storage.getConfiguration().setTimeZone(timeZoneValue);
                this.storage.getConfiguration().update();
                break;
            }
            case LOCALECOUNTRY: {
                this.storage.getConfiguration().setLocaleCountry(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case LOCALELANGUAGE: {
                this.storage.getConfiguration().setLocaleLanguage(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case CHARSET: {
                this.storage.getConfiguration().setCharset(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if ("clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustomInternal();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (customValue.isEmpty()) {
                    this.removeCustomInternal(customName);
                    break;
                }
                this.setCustomInternal(customName, customValue);
                break;
            }
            case CLUSTERSELECTION: {
                this.storage.getConfiguration().setClusterSelection(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case MINIMUMCLUSTERS: {
                if (iValue != null) {
                    if (iValue instanceof Number) {
                        this.storage.getConfiguration().setMinimumClusters(((Number)iValue).intValue());
                    } else {
                        this.storage.getConfiguration().setMinimumClusters(Integer.parseInt(stringValue));
                    }
                } else {
                    this.storage.getConfiguration().setMinimumClusters(1);
                }
                this.storage.getConfiguration().update();
                break;
            }
            case CONFLICTSTRATEGY: {
                this.storage.setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(stringValue));
                this.storage.getConfiguration().setConflictStrategy(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case VALIDATION: {
                this.storage.getConfiguration().setValidation(Boolean.parseBoolean(stringValue));
                this.storage.getConfiguration().update();
                break;
            }
            default: {
                throw new IllegalArgumentException("Option '" + (Object)((Object)iAttribute) + "' not supported on alter database");
            }
        }
        return (DB)this;
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        this.checkIfActive();
        return this.storage.getRecordMetadata(rid);
    }

    @Override
    public OTransaction getTransaction() {
        this.checkIfActive();
        return this.currentTx;
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, !iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, null, false);
    }

    @Override
    public <RET extends ORecord> RET load(ORID recordId) {
        return (RET)this.currentTx.loadRecord(recordId, null, null, false);
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecord> RET loadIfVersionIsNotLatest(ORID rid, int recordVersion, String fetchPlan, boolean ignoreCache) throws ORecordNotFoundException {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecordIfVersionIsNotLatest(rid, recordVersion, fetchPlan, ignoreCache);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, iLockingStrategy);
    }

    public <RET extends ORecord> RET reload(ORecord iRecord) {
        return this.reload(iRecord, (String)null, false);
    }

    public <RET extends ORecord> RET reload(ORecord iRecord, String iFetchPlan) {
        return this.reload(iRecord, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.reload(iRecord, iFetchPlan, iIgnoreCache, true);
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord record, String fetchPlan, boolean ignoreCache, boolean force) {
        this.checkIfActive();
        ORecord loadedRecord = this.currentTx.reloadRecord(record.getIdentity(), record, fetchPlan, ignoreCache, force);
        if (loadedRecord != null && record != loadedRecord) {
            record.fromStream(loadedRecord.toStream());
            ORecordInternal.setVersion(record, loadedRecord.getVersion());
        } else if (loadedRecord == null) {
            throw new ORecordNotFoundException(record.getIdentity());
        }
        return (RET)record;
    }

    public ODatabaseDocument delete(ORID iRecord) {
        this.checkOpeness();
        this.checkIfActive();
        Object rec = iRecord.getRecord();
        if (rec != null) {
            rec.delete();
        }
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        this.checkOpeness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            throw new ODatabaseException("This operation can be executed only in non transaction mode");
        }
        return this.executeHideRecord(rid, ODatabase.OPERATION_MODE.SYNCHRONOUS);
    }

    @Override
    public OBinarySerializerFactory getSerializerFactory() {
        return this.componentsFactory.binarySerializerFactory;
    }

    public ODatabaseDocument begin(OTransaction iTx) {
        this.checkOpeness();
        this.checkIfActive();
        if (this.currentTx.isActive() && iTx.equals(this.currentTx)) {
            this.currentTx.begin();
            return this;
        }
        this.currentTx.rollback(true, 0);
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin(this);
            }
            catch (Exception e) {
                String message = "Error before the transaction begin";
                OLogManager.instance().error((Object)this, "Error before the transaction begin", e, new Object[0]);
                throw OException.wrapException(new OTransactionBlockedException("Error before the transaction begin"), e);
            }
        }
        this.currentTx = iTx;
        this.currentTx.begin();
        return this;
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, -1, iFetchPlan, iIgnoreCache, !iIgnoreCache, false, OStorage.LOCKING_STRATEGY.NONE, new SimpleRecordReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ORecord> executeReadRecords(Set<ORecordId> iRids, boolean ignoreCache) {
        this.checkOpeness();
        this.checkIfActive();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        ORecordSerializationContext.pushContext();
        try {
            HashSet<ORecord> records = new HashSet<ORecord>(iRids.size() > 0 ? iRids.size() : 1);
            if (iRids.isEmpty()) {
                HashSet<ORecord> hashSet = records;
                return hashSet;
            }
            ArrayList<ORecordId> rids = new ArrayList<ORecordId>(iRids);
            Iterator it = rids.iterator();
            while (it.hasNext()) {
                ORecordId rid = (ORecordId)it.next();
                ORecord record = this.getTransaction().getRecord(rid);
                if (record == OTransactionRealAbstract.DELETED_RECORD) {
                    it.remove();
                    continue;
                }
                if (record == null && !ignoreCache) {
                    record = this.getLocalCache().findRecord(rid);
                }
                if (record == null) continue;
                records.add(record);
                it.remove();
            }
            Collection<OPair<ORecordId, ORawBuffer>> rawRecords = ((OAbstractPaginatedStorage)this.storage.getUnderlying()).readRecords(rids);
            for (OPair<ORecordId, ORawBuffer> entry : rawRecords) {
                ORecord record = Orient.instance().getRecordFactoryManager().newInstance(((ORawBuffer)entry.value).recordType);
                ORecordInternal.fill(record, (ORID)entry.key, ((ORawBuffer)entry.value).version, ((ORawBuffer)entry.value).buffer, false);
                records.add(record);
            }
            HashSet<ORecord> hashSet = records;
            return hashSet;
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    public <RET extends ORecord> RET executeReadRecord(ORecordId rid, ORecord iRecord, int recordVersion, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstones, OStorage.LOCKING_STRATEGY lockingStrategy, RecordReader recordReader) {
        this.checkOpeness();
        this.checkIfActive();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        ORecordSerializationContext.pushContext();
        try {
            ORawBuffer recordBuffer;
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)this.getClusterNameById(rid.getClusterId()));
            ORecord record = this.getTransaction().getRecord(rid);
            if (record == OTransactionRealAbstract.DELETED_RECORD) {
                RET RET = null;
                return RET;
            }
            if (record == null && !ignoreCache) {
                record = this.getLocalCache().findRecord(rid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    ORecordInternal.setVersion(iRecord, record.getVersion());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid(fetchPlan);
                if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, record) == ORecordHook.RESULT.SKIP) {
                    RET RET = null;
                    return RET;
                }
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + (Object)((Object)lockingStrategy), new Object[0]);
                    record.lock(false);
                } else if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + (Object)((Object)lockingStrategy), new Object[0]);
                    record.lock(true);
                }
                this.callbackHooks(ORecordHook.TYPE.AFTER_READ, record);
                if (record instanceof ODocument) {
                    ODocumentInternal.checkClass((ODocument)record, this);
                }
                ORecord oRecord = record;
                return (RET)oRecord;
            }
            if (!rid.isValid()) {
                recordBuffer = null;
            } else {
                OFetchHelper.checkFetchPlanValid(fetchPlan);
                int version = iRecord != null ? iRecord.getVersion() : recordVersion;
                recordBuffer = recordReader.readRecord(this.storage, rid, fetchPlan, ignoreCache, version);
            }
            if (recordBuffer == null) {
                RET RET = null;
                return RET;
            }
            if (iRecord == null || ORecordInternal.getRecordType(iRecord) != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType);
            }
            ORecordInternal.fill(iRecord, rid, recordBuffer.version, recordBuffer.buffer, false);
            if (iRecord instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)iRecord, this);
            }
            if (ORecordVersionHelper.isTombstone(iRecord.getVersion())) {
                ORecord oRecord = iRecord;
                return (RET)oRecord;
            }
            if (this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord) == ORecordHook.RESULT.SKIP) {
                RET RET = null;
                return RET;
            }
            iRecord.fromStream(recordBuffer.buffer);
            this.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
            if (iUpdateCache) {
                this.getLocalCache().updateRecord(iRecord);
            }
            ORecord oRecord = iRecord;
            return (RET)oRecord;
        }
        catch (OOfflineClusterException t) {
            throw t;
        }
        catch (ORecordNotFoundException t) {
            throw t;
        }
        catch (Throwable t) {
            if (rid.isTemporary()) {
                throw OException.wrapException(new ODatabaseException("Error on retrieving record using temporary RID: " + rid), t);
            }
            throw OException.wrapException(new ODatabaseException("Error on retrieving record " + rid + " (cluster: " + this.storage.getPhysicalClusterNameById(rid.clusterId) + ")"), t);
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    @Override
    public int assignAndCheckCluster(ORecord record, String iClusterName) {
        ORecordId rid = (ORecordId)record.getIdentity();
        if ((long)rid.clusterId <= -1L && iClusterName != null) {
            rid.clusterId = this.getClusterIdByName(iClusterName);
            if (rid.clusterId == -1) {
                throw new IllegalArgumentException("Cluster name '" + iClusterName + "' is not configured");
            }
        }
        OImmutableClass schemaClass = null;
        if (rid.getClusterId() <= -1 && this.storage.isAssigningClusterIds()) {
            if (record instanceof ODocument) {
                schemaClass = ODocumentInternal.getImmutableSchemaClass((ODocument)record);
                if (schemaClass != null) {
                    if (schemaClass.isAbstract()) {
                        throw new OSchemaException("Document belongs to abstract class " + schemaClass.getName() + " and cannot be saved");
                    }
                    rid.clusterId = schemaClass.getClusterForNewInstance((ODocument)record);
                } else {
                    rid.clusterId = this.getDefaultClusterId();
                }
            } else {
                rid.clusterId = this.getDefaultClusterId();
                if (record instanceof OBlob && rid.clusterId != -1) {
                    // empty if block
                }
            }
        } else if (record instanceof ODocument) {
            schemaClass = ODocumentInternal.getImmutableSchemaClass((ODocument)record);
        }
        if (rid.getClusterId() > -1 && schemaClass != null) {
            String messageClusterName = this.getClusterNameById(rid.getClusterId());
            this.checkRecordClass(schemaClass, messageClusterName, rid);
            if (!schemaClass.hasClusterId(rid.getClusterId())) {
                throw new IllegalArgumentException("Cluster name '" + messageClusterName + "' (id=" + rid.getClusterId() + ") is not configured to store the class '" + schemaClass.getName() + "', valid are " + Arrays.toString(schemaClass.getClusterIds()));
            }
        }
        return rid.getClusterId();
    }

    public <RET extends ORecord> RET executeSaveEmptyRecord(ORecord record, String clusterName) {
        ORecordId rid = (ORecordId)record.getIdentity();
        assert (rid.isNew());
        ORecordInternal.onBeforeIdentityChanged(record);
        int id = this.assignAndCheckCluster(record, clusterName);
        clusterName = this.getClusterNameById(id);
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_CREATE, (Object)clusterName);
        byte[] content = this.getSerializer().writeClassOnly(record);
        OStorageOperationResult<OPhysicalPosition> ppos = this.storage.createRecord(rid, content, record.getVersion(), this.recordType, ODatabase.OPERATION_MODE.SYNCHRONOUS.ordinal(), null);
        ORecordInternal.setVersion(record, ppos.getResult().recordVersion);
        ((ORecordId)record.getIdentity()).copyFrom(rid);
        ORecordInternal.onAfterIdentityChanged(record);
        return (RET)record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET extends ORecord> RET executeSaveRecord(ORecord record, String clusterName, int ver, ODatabase.OPERATION_MODE mode, boolean forceCreate, ORecordCallback<? extends Number> recordCreatedCallback, ORecordCallback<Integer> recordUpdatedCallback) {
        this.checkOpeness();
        this.checkIfActive();
        if (!record.isDirty()) {
            return (RET)record;
        }
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
        try {
            OStorageOperationResult<Integer> operationResult;
            boolean isNew;
            byte[] stream;
            block29: {
                ORecordHook.RESULT hookResult;
                block30: {
                    ORecord oRecord;
                    stream = null;
                    this.getMetadata().makeThreadLocalSchemaSnapshot();
                    if (record instanceof ODocument) {
                        ODocumentInternal.checkClass((ODocument)record, this);
                    }
                    ORecordSerializationContext.pushContext();
                    isNew = forceCreate || rid.isNew();
                    try {
                        ORecordHook.TYPE triggerType;
                        if (isNew) {
                            ORecordInternal.onBeforeIdentityChanged(record);
                            int id = this.assignAndCheckCluster(record, clusterName);
                            clusterName = this.getClusterNameById(id);
                            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_CREATE, (Object)clusterName);
                            triggerType = ORecordHook.TYPE.BEFORE_CREATE;
                        } else {
                            clusterName = this.getClusterNameById(record.getIdentity().getClusterId());
                            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_UPDATE, (Object)clusterName);
                            triggerType = ORecordHook.TYPE.BEFORE_UPDATE;
                        }
                        stream = record.toStream();
                        hookResult = this.callbackHooks(triggerType, record);
                        if (hookResult == ORecordHook.RESULT.RECORD_CHANGED) {
                            if (record instanceof ODocument) {
                                ((ODocument)record).validate();
                            }
                            stream = this.updateStream(record);
                            break block29;
                        }
                        if (hookResult != ORecordHook.RESULT.SKIP_IO) break block30;
                        oRecord = record;
                        this.callbackHookFinalize(record, isNew, stream);
                    }
                    catch (Throwable throwable) {
                        this.callbackHookFinalize(record, isNew, stream);
                        ORecordSerializationContext.pullContext();
                        this.getMetadata().clearThreadLocalSchemaSnapshot();
                        ORecordSaveThreadLocal.removeLast();
                        throw throwable;
                    }
                    ORecordSerializationContext.pullContext();
                    this.getMetadata().clearThreadLocalSchemaSnapshot();
                    ORecordSaveThreadLocal.removeLast();
                    return (RET)oRecord;
                }
                if (hookResult != ORecordHook.RESULT.RECORD_REPLACED) break block29;
                ORecord oRecord = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
                this.callbackHookFinalize(record, isNew, stream);
                ORecordSerializationContext.pullContext();
                this.getMetadata().clearThreadLocalSchemaSnapshot();
                ORecordSaveThreadLocal.removeLast();
                return (RET)oRecord;
            }
            ORecordSaveThreadLocal.setLast(record);
            try {
                boolean updateContent = ORecordInternal.isContentChanged(record);
                byte[] content = stream == null ? OCommonConst.EMPTY_BYTE_ARRAY : stream;
                byte recordType = ORecordInternal.getRecordType(record);
                int modeIndex = mode.ordinal();
                Orient.instance().getRecordFactoryManager().getRecordTypeClass(recordType);
                if (forceCreate || ORecordId.isNew(rid.clusterPosition)) {
                    OStorageOperationResult<OPhysicalPosition> ppos = this.storage.createRecord(rid, content, ver, recordType, modeIndex, recordCreatedCallback);
                    operationResult = new OStorageOperationResult<Integer>(ppos.getResult().recordVersion, ppos.isMoved());
                } else {
                    operationResult = this.storage.updateRecord(rid, updateContent, content, ver, recordType, modeIndex, recordUpdatedCallback);
                }
                int version = operationResult.getResult();
                if (isNew) {
                    ((ORecordId)record.getIdentity()).copyFrom(rid);
                    ORecordInternal.onAfterIdentityChanged(record);
                }
                if (operationResult.getModifiedRecordContent() != null) {
                    stream = operationResult.getModifiedRecordContent();
                } else if (version > record.getVersion() + 1) {
                    record.unload();
                }
                ORecordInternal.fill(record, rid, version, stream, false);
                this.callbackHookSuccess(record, isNew, stream, operationResult);
            }
            catch (Exception t) {
                this.callbackHookFailure(record, isNew, stream);
                throw t;
            }
            this.callbackHookFinalize(record, isNew, stream);
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
            ORecordSaveThreadLocal.removeLast();
            if (stream != null && stream.length > 0 && !operationResult.isMoved()) {
                this.getLocalCache().updateRecord(record);
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception t) {
            if (!ORecordId.isValid(record.getIdentity().getClusterPosition())) {
                throw OException.wrapException(new ODatabaseException("Error on saving record in cluster #" + record.getIdentity().getClusterId()), t);
            }
            throw OException.wrapException(new ODatabaseException("Error on saving record " + record.getIdentity()), t);
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return (RET)record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDeleteRecord(OIdentifiable record, int iVersion, boolean iRequired, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpeness();
        this.checkIfActive();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        if ((record = record.getRecord()) == null) {
            return;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        ORecordSerializationContext.pushContext();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        try {
            if (record instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)record, this);
            }
            try {
                OStorageOperationResult<Boolean> operationResult;
                Object rec = record.getRecord();
                if (rec != null) {
                    this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, (OIdentifiable)rec);
                    if (rec instanceof ODocument) {
                        ORidBagDeleter.deleteAllRidBags((ODocument)rec);
                    }
                }
                try {
                    if (prohibitTombstones) {
                        boolean result = this.storage.cleanOutRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!result && iRequired) {
                            throw new ORecordNotFoundException(rid);
                        }
                        operationResult = new OStorageOperationResult<Boolean>(result);
                    } else {
                        OStorageOperationResult<Boolean> result = this.storage.deleteRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!result.getResult().booleanValue() && iRequired) {
                            throw new ORecordNotFoundException(rid);
                        }
                        operationResult = new OStorageOperationResult<Boolean>(result.getResult());
                    }
                    if (!operationResult.isMoved() && rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, (OIdentifiable)rec);
                    } else if (rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.DELETE_REPLICATED, (OIdentifiable)rec);
                    }
                }
                catch (Exception t) {
                    this.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, (OIdentifiable)rec);
                    throw t;
                }
                finally {
                    this.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, (OIdentifiable)rec);
                }
                this.clearDocumentTracking((ORecord)rec);
                if (!operationResult.isMoved()) {
                    this.getLocalCache().deleteRecord(rid);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception t) {
                throw OException.wrapException(new ODatabaseException("Error on deleting record in cluster #" + record.getIdentity().getClusterId()), t);
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeHideRecord(OIdentifiable record, ODatabase.OPERATION_MODE iMode) {
        this.checkOpeness();
        this.checkIfActive();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot hide record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return false;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        if (record instanceof ODocument) {
            ODocumentInternal.checkClass((ODocument)record, this);
        }
        ORecordSerializationContext.pushContext();
        try {
            OStorageOperationResult<Boolean> operationResult = this.storage.hideRecord(rid, iMode.ordinal(), null);
            if (!operationResult.isMoved()) {
                this.getLocalCache().deleteRecord(rid);
            }
            boolean bl = operationResult.getResult();
            return bl;
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    public ODatabaseDocumentTx begin() {
        return this.begin(OTransaction.TXTYPE.OPTIMISTIC);
    }

    public ODatabaseDocumentTx begin(OTransaction.TXTYPE iType) {
        this.checkOpeness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        if (!this.inHook.isEmpty()) {
            throw new IllegalStateException("Cannot begin a transaction while a hook is executing");
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin(this);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", t, new Object[0]);
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimistic(this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public void setDefaultTransactionMode() {
        if (!(this.currentTx instanceof OTransactionNoTx)) {
            this.currentTx = new OTransactionNoTx(this);
        }
    }

    @Override
    public void freeze(boolean throwException) {
        this.checkOpeness();
        if (!(this.getStorage() instanceof OFreezableStorageComponent)) {
            OLogManager.instance().error((Object)this, "Only local paginated storage supports freeze. If you are using remote client please use OServerAdmin instead", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        OFreezableStorageComponent storage = this.getFreezableStorage();
        if (storage != null) {
            storage.freeze(throwException);
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void freeze() {
        this.checkOpeness();
        if (!(this.getStorage() instanceof OFreezableStorageComponent)) {
            OLogManager.instance().error((Object)this, "Only local paginated storage supports freeze. If you use remote client please use OServerAdmin instead", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        OFreezableStorageComponent storage = this.getFreezableStorage();
        if (storage != null) {
            storage.freeze(false);
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void release() {
        this.checkOpeness();
        if (!(this.getStorage() instanceof OFreezableStorageComponent)) {
            OLogManager.instance().error((Object)this, "Only local paginated storage supports release. If you are using remote client please use OServerAdmin instead", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        OFreezableStorageComponent storage = this.getFreezableStorage();
        if (storage != null) {
            storage.release();
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".release", "Time to release the database", startTime, "db.*.release");
    }

    @Override
    public ODocument newInstance() {
        return new ODocument();
    }

    @Override
    public ODocument newInstance(String iClassName) {
        return new ODocument(iClassName);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        if (this.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName) == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in current database");
        }
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iClassName);
        return new ORecordIteratorClass<ODocument>((ODatabaseDocumentInternal)this, (ODatabaseDocumentInternal)this, iClassName, iPolymorphic, false);
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, this, this.getClusterIdByName(iClusterName));
    }

    @Override
    public Iterable<ODatabaseListener> getListeners() {
        return this.getListenersCopy();
    }

    @Deprecated
    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, this, this.getClusterIdByName(iClusterName), startClusterPosition, endClusterPosition, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord) {
        return this.save(iRecord, (String)null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<Integer>)null);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        return this.save(iRecord, (String)null, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName) {
        return this.save(iRecord, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<Integer>)null);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.checkOpeness();
        if (!(iRecord instanceof ODocument)) {
            this.assignAndCheckCluster(iRecord, iClusterName);
            return (RET)this.currentTx.saveRecord(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        }
        ODocument doc = (ODocument)iRecord;
        ODocumentInternal.checkClass(doc, this);
        if (!this.getTransaction().isActive() && !this.storage.isRemote()) {
            doc.validate();
        }
        ODocumentInternal.convertAllMultiValuesToTrackedVersions(doc);
        if (iForceCreate || !doc.getIdentity().isValid()) {
            if (doc.getClassName() != null) {
                this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)doc.getClassName());
            }
            this.assignAndCheckCluster(doc, iClusterName);
        } else if (doc.getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_UPDATE, (Object)doc.getClassName());
        }
        doc = (ODocument)this.currentTx.saveRecord(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        return (RET)doc;
    }

    public ODatabaseDocumentTx delete(ORecord record) {
        this.checkOpeness();
        if (record == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (record instanceof ODocument && ((ODocument)record).getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)((ODocument)record).getClassName());
        }
        try {
            this.currentTx.deleteRecord(record, ODatabase.OPERATION_MODE.SYNCHRONOUS);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            if (record instanceof ODocument) {
                throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity() + " of class '" + ((ODocument)record).getClassName() + "'"), e);
            }
            throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity()), e);
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        return this.countClass(iClassName, true);
    }

    @Override
    public long countClass(String iClassName, boolean iPolymorphic) {
        OClass cls = this.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in database");
        }
        long totalOnDb = cls.count(iPolymorphic);
        long deletedInTx = 0L;
        long addedInTx = 0L;
        if (this.getTransaction().isActive()) {
            for (ORecordOperation oRecordOperation : this.getTransaction().getAllRecordEntries()) {
                OClass schemaClass;
                ORecord rec;
                if (oRecordOperation.type == 2 && (rec = oRecordOperation.getRecord()) != null && rec instanceof ODocument) {
                    schemaClass = ((ODocument)rec).getSchemaClass();
                    if (iPolymorphic) {
                        if (schemaClass.isSubClassOf(iClassName)) {
                            ++deletedInTx;
                        }
                    } else if (iClassName.equals(schemaClass.getName()) || iClassName.equals(schemaClass.getShortName())) {
                        ++deletedInTx;
                    }
                }
                if (oRecordOperation.type != 3 || (rec = oRecordOperation.getRecord()) == null || !(rec instanceof ODocument)) continue;
                schemaClass = ((ODocument)rec).getSchemaClass();
                if (iPolymorphic) {
                    if (!schemaClass.isSubClassOf(iClassName)) continue;
                    ++addedInTx;
                    continue;
                }
                if (!iClassName.equals(schemaClass.getName()) && !iClassName.equals(schemaClass.getShortName())) continue;
                ++addedInTx;
            }
        }
        return totalOnDb + addedInTx - deletedInTx;
    }

    @Override
    public ODatabase<ORecord> commit() {
        return this.commit(false);
    }

    public ODatabaseDocument commit(boolean force) throws OTransactionException {
        this.checkOpeness();
        this.checkIfActive();
        if (!this.currentTx.isActive()) {
            return this;
        }
        if (!force && this.currentTx.amountOfNestedTxs() > 1) {
            this.currentTx.commit();
            return this;
        }
        for (Iterator listener : this.browseListeners()) {
            try {
                listener.onBeforeTxCommit(this);
            }
            catch (Exception e) {
                this.rollback(force);
                OLogManager.instance().error((Object)this, "Cannot commit the transaction: caught exception on execution of %s.onBeforeTxCommit()", listener.getClass().getName(), e);
                throw OException.wrapException(new OTransactionException("Cannot commit the transaction: caught exception on execution of " + listener.getClass().getName() + "#onBeforeTxCommit()"), e);
            }
        }
        try {
            this.currentTx.commit(force);
        }
        catch (RuntimeException e) {
            OLogManager.instance().debug((Object)this, "Error on transaction commit", e, new Object[0]);
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onBeforeTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before transaction rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback(false, 0);
            this.getLocalCache().clear();
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onAfterTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after transaction rollback", t, new Object[0]);
                }
            }
            throw e;
        }
        for (Iterator listener : this.browseListeners()) {
            try {
                listener.onAfterTxCommit(this);
            }
            catch (Exception e) {
                String message = "Error after the transaction has been committed. The transaction remains valid. The exception caught was on execution of " + listener.getClass() + ".onAfterTxCommit()";
                OLogManager.instance().error((Object)this, message, e, new Object[0]);
                throw OException.wrapException(new OTransactionBlockedException(message), e);
            }
        }
        return this;
    }

    @Override
    public OUncompletedCommit<Void> initiateCommit() {
        return this.initiateCommit(false);
    }

    @Override
    public OUncompletedCommit<Void> initiateCommit(boolean force) {
        this.checkOpeness();
        this.checkIfActive();
        if (!this.currentTx.isActive()) {
            return OUncompletedCommit.NO_OPERATION;
        }
        if (!force && this.currentTx.amountOfNestedTxs() > 1) {
            return new UncompletedCommit(false, this.currentTx.initiateCommit(false));
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxCommit(this);
            }
            catch (Exception e) {
                this.rollback(force);
                OLogManager.instance().error((Object)this, "Cannot commit the transaction: caught exception on execution of %s.onBeforeTxCommit()", listener.getClass().getName(), e);
                throw OException.wrapException(new OTransactionException("Cannot commit the transaction: caught exception on execution of " + listener.getClass().getName() + "#onBeforeTxCommit()"), e);
            }
        }
        try {
            return new UncompletedCommit(true, this.currentTx.initiateCommit(force));
        }
        catch (RuntimeException e) {
            OLogManager.instance().debug((Object)this, "Error on transaction commit", e, new Object[0]);
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onBeforeTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before transaction rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback(false, 0);
            this.getLocalCache().clear();
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onAfterTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after transaction rollback", t, new Object[0]);
                }
            }
            throw e;
        }
    }

    @Override
    public ODatabase<ORecord> rollback() {
        return this.rollback(false);
    }

    public ODatabaseDocument rollback(boolean force) throws OTransactionException {
        this.checkOpeness();
        if (this.currentTx.isActive()) {
            if (!force && this.currentTx.amountOfNestedTxs() > 1) {
                this.currentTx.rollback();
                return this;
            }
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onBeforeTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before transactional rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback(force, -1);
            for (ODatabaseListener listener : this.browseListeners()) {
                try {
                    listener.onAfterTxRollback(this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after transaction rollback", t, new Object[0]);
                }
            }
        }
        this.getLocalCache().clear();
        return this;
    }

    @Override
    public <DB extends ODatabase> DB getUnderlying() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OStorage getStorage() {
        return this.storage;
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.storage = iNewStorage;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return this.storage.callInLock(iCallable, iExclusiveLock);
    }

    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        return this.storage.backup(out, options, callable, iListener, compressionLevel, bufferSize);
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        if (this.storage == null) {
            this.storage = Orient.instance().loadStorage(this.url);
        }
        this.getStorage().restore(in, options, callable, iListener);
        if (!this.isClosed()) {
            this.getMetadata().reload();
        }
    }

    @Override
    public OSBTreeCollectionManager getSbTreeCollectionManager() {
        return this.getStorage().getSBtreeCollectionManager();
    }

    @Override
    public OCurrentStorageComponentsFactory getStorageVersions() {
        return this.componentsFactory;
    }

    @Override
    public ORecordSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ORecordSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void resetInitialization() {
        for (ORecordHook h : this.hooks.keySet()) {
            h.onUnregister();
        }
        this.hooks.clear();
        this.close();
        this.initialized = false;
    }

    @Override
    public String incrementalBackup(String path) {
        this.checkOpeness();
        this.checkIfActive();
        return this.storage.incrementalBackup(path);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            this.checkSecurity(resourceGeneric, null, iOperation);
        }
        return this.checkSecurity(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        if (iResourceSpecific == null || iResourceSpecific.equals("*")) {
            return this.checkSecurity(resourceGeneric, iOperation, (Object)null);
        }
        return this.checkSecurity(resourceGeneric, iOperation, iResourceSpecific);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        return this.checkSecurity(resourceGeneric, iOperation, iResourcesSpecific);
    }

    @Override
    public boolean isPooled() {
        return false;
    }

    @Deprecated
    public void setCurrentDatabaseInThreadLocal() {
        this.activateOnCurrentThread();
    }

    @Override
    public ODatabaseDocumentTx activateOnCurrentThread() {
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.INSTANCE;
        if (tl != null) {
            tl.set(this);
        }
        return this;
    }

    @Override
    public boolean isActiveOnCurrentThread() {
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.INSTANCE;
        ODatabaseDocumentInternal db = tl != null ? tl.getIfDefined() : null;
        return db == this;
    }

    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }

    private void popInHook(OIdentifiable id) {
        this.inHook.remove(id);
    }

    private boolean pushInHook(OIdentifiable id) {
        return this.inHook.add(id);
    }

    private void initAtFirstOpen(String iUserName, String iUserPassword) {
        if (this.initialized) {
            return;
        }
        ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
        String serializeName = this.getStorage().getConfiguration().getRecordSerializer();
        if (serializeName == null) {
            serializeName = "ORecordDocument2csv";
        }
        this.serializer = serializerFactory.getFormat(serializeName);
        if (this.serializer == null) {
            throw new ODatabaseException("RecordSerializer with name '" + serializeName + "' not found ");
        }
        if (this.getStorage().getConfiguration().getRecordSerializerVersion() > this.serializer.getMinSupportedVersion()) {
            throw new ODatabaseException("Persistent record serializer version is not support by the current implementation");
        }
        this.componentsFactory = this.getStorage().getComponentsFactory();
        this.localCache.startup();
        this.user = null;
        this.metadata = new OMetadataDefault(this);
        this.metadata.load();
        this.recordFormat = DEF_RECORD_FORMAT;
        if (!(this.getStorage() instanceof OStorageProxy)) {
            if (this.metadata.getIndexManager().autoRecreateIndexesAfterCrash()) {
                this.metadata.getIndexManager().recreateIndexes();
                this.activateOnCurrentThread();
                this.user = null;
            }
            this.installHooksEmbedded();
            this.registerHook(new OCommandCacheHook(this), ORecordHook.HOOK_POSITION.REGULAR);
            this.registerHook(new OSecurityTrackerHook(this.metadata.getSecurity(), this), ORecordHook.HOOK_POSITION.LAST);
            this.user = null;
        } else if (iUserName != null && iUserPassword != null) {
            this.user = new OImmutableUser(-1L, new OUser(iUserName, OUser.encryptPassword(iUserPassword)).addRole(new ORole("passthrough", null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT)));
            this.installHooksRemote();
        }
        this.initialized = true;
    }

    private void installHooksEmbedded() {
        this.hooks.clear();
        this.registerHook(new OClassTrigger(this), ORecordHook.HOOK_POSITION.FIRST);
        this.registerHook(new ORestrictedAccessHook(this), ORecordHook.HOOK_POSITION.FIRST);
        this.registerHook(new OUserTrigger(this), ORecordHook.HOOK_POSITION.EARLY);
        this.registerHook(new OFunctionTrigger(this), ORecordHook.HOOK_POSITION.REGULAR);
        this.registerHook(new OSequenceTrigger(this), ORecordHook.HOOK_POSITION.REGULAR);
        this.registerHook(new OClassIndexManager(this), ORecordHook.HOOK_POSITION.LAST);
        this.registerHook(new OSchedulerTrigger(this), ORecordHook.HOOK_POSITION.LAST);
        this.registerHook(new OLiveQueryHook(this), ORecordHook.HOOK_POSITION.LAST);
    }

    private void installHooksRemote() {
        this.hooks.clear();
        this.registerHook(new ClassIndexManagerRemote(this), ORecordHook.HOOK_POSITION.LAST);
    }

    private void closeOnDelete() {
        if (this.status != ODatabase.STATUS.OPEN) {
            return;
        }
        if (this.currentIntent != null) {
            this.currentIntent.end(this);
            this.currentIntent = null;
        }
        this.resetListeners();
        if (this.storage != null) {
            this.storage.close(true, true);
        }
        this.storage = null;
        this.status = ODatabase.STATUS.CLOSED;
    }

    private void clearCustomInternal() {
        this.storage.getConfiguration().clearProperties();
    }

    private void removeCustomInternal(String iName) {
        this.setCustomInternal(iName, null);
    }

    private void setCustomInternal(String iName, String iValue) {
        if (iValue == null || "null".equalsIgnoreCase(iValue)) {
            this.storage.getConfiguration().removeProperty(iName);
        } else {
            this.storage.getConfiguration().setProperty(iName, iValue);
        }
        this.storage.getConfiguration().update();
    }

    private void callbackHookFailure(ORecord record, boolean wasNew, byte[] stream) {
        if (stream != null && stream.length > 0) {
            this.callbackHooks(wasNew ? ORecordHook.TYPE.CREATE_FAILED : ORecordHook.TYPE.UPDATE_FAILED, record);
        }
    }

    private void callbackHookSuccess(ORecord record, boolean wasNew, byte[] stream, OStorageOperationResult<Integer> operationResult) {
        if (stream != null && stream.length > 0) {
            ORecordHook.TYPE hookType = !operationResult.isMoved() ? (wasNew ? ORecordHook.TYPE.AFTER_CREATE : ORecordHook.TYPE.AFTER_UPDATE) : (wasNew ? ORecordHook.TYPE.CREATE_REPLICATED : ORecordHook.TYPE.UPDATE_REPLICATED);
            this.callbackHooks(hookType, record);
        }
    }

    private void callbackHookFinalize(ORecord record, boolean wasNew, byte[] stream) {
        if (stream != null && stream.length > 0) {
            ORecordHook.TYPE hookType = wasNew ? ORecordHook.TYPE.FINALIZE_CREATION : ORecordHook.TYPE.FINALIZE_UPDATE;
            this.callbackHooks(hookType, record);
            this.clearDocumentTracking(record);
        }
    }

    private void clearDocumentTracking(ORecord record) {
        if (record instanceof ODocument && ((ODocument)record).isTrackingChanges()) {
            ODocumentInternal.clearTrackData((ODocument)record);
        }
    }

    private void checkRecordClass(OClass recordClass, String iClusterName, ORecordId rid) {
        if (this.getStorageVersions().classesAreDetectedByClusterId()) {
            OClass clusterIdClass = this.metadata.getImmutableSchemaSnapshot().getClassByClusterId(rid.clusterId);
            if (recordClass == null && clusterIdClass != null || clusterIdClass == null && recordClass != null || recordClass != null && !recordClass.equals(clusterIdClass)) {
                throw new IllegalArgumentException("Record saved into cluster '" + iClusterName + "' should be saved with class '" + clusterIdClass + "' but has been created with class '" + recordClass + "'");
            }
        }
    }

    private byte[] updateStream(ORecord record) {
        ORecordSerializationContext.pullContext();
        ODirtyManager manager = ORecordInternal.getDirtyManager(record);
        Set<ORecord> newRecords = manager.getNewRecords();
        Set<ORecord> updatedRecords = manager.getUpdateRecords();
        manager.clearForSave();
        if (newRecords != null) {
            for (ORecord newRecord : newRecords) {
                if (newRecord == record) continue;
                this.getTransaction().saveRecord(newRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
        if (updatedRecords != null) {
            for (ORecord updatedRecord : updatedRecords) {
                if (updatedRecord == record) continue;
                this.getTransaction().saveRecord(updatedRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
        ORecordSerializationContext.pushContext();
        ORecordInternal.unsetDirty(record);
        record.setDirty();
        return record.toStream();
    }

    private void init() {
        this.currentTx = new OTransactionNoTx(this);
    }

    private OFreezableStorageComponent getFreezableStorage() {
        OStorage s = this.getStorage();
        if (s instanceof OFreezableStorageComponent) {
            return (OFreezableStorageComponent)((Object)s);
        }
        OLogManager.instance().error((Object)this, "Storage of type " + s.getType() + " does not support freeze operation", new Object[0]);
        return null;
    }

    public void checkIfActive() {
        ODatabaseDocumentInternal currentDatabase;
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.INSTANCE;
        ODatabaseDocumentInternal oDatabaseDocumentInternal = currentDatabase = tl != null ? tl.get() : null;
        if (currentDatabase != this) {
            throw new IllegalStateException("The current database instance (" + this.toString() + ") is not active on the current thread (" + Thread.currentThread() + "). Current active database is: " + currentDatabase);
        }
    }

    @Override
    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        int id;
        if (this.getStorage() instanceof OStorageProxy) {
            id = (Integer)this.command(new OCommandSQL("create blob cluster :1")).execute(iClusterName);
            this.getMetadata().getSchema().reload();
        } else {
            id = !this.existsCluster(iClusterName) ? this.addCluster(iClusterName, iParameters) : this.getClusterIdByName(iClusterName);
            this.getMetadata().getSchema().addBlobCluster(id);
        }
        return id;
    }

    @Override
    public Set<Integer> getBlobClusterIds() {
        return this.getMetadata().getSchema().getBlobClusters();
    }

    public static Object executeWithRetries(OCallable<Object, Integer> callback, int maxRetry) {
        return ODatabaseDocumentTx.executeWithRetries(callback, maxRetry, 0);
    }

    public static Object executeWithRetries(OCallable<Object, Integer> callback, int maxRetry, int waitBetweenRetry) {
        ONeedRetryException lastException = null;
        for (int retry = 0; retry < maxRetry; ++retry) {
            try {
                return callback.call(retry);
            }
            catch (ONeedRetryException e) {
                lastException = e;
                if (waitBetweenRetry <= 0) continue;
                try {
                    Thread.sleep(waitBetweenRetry);
                    continue;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw lastException;
    }

    static {
        if (defaultSerializer == null) {
            throw new ODatabaseException("Impossible to find serializer with name " + OGlobalConfiguration.DB_DOCUMENT_SERIALIZER.getValueAsString());
        }
    }

    private class UncompletedCommit
    implements OUncompletedCommit<Void> {
        private final boolean topLevel;
        private final OUncompletedCommit<Void> nestedCommit;

        public UncompletedCommit(boolean topLevel, OUncompletedCommit<Void> nestedCommit) {
            this.topLevel = topLevel;
            this.nestedCommit = nestedCommit;
        }

        @Override
        public Void complete() {
            ODatabaseDocumentTx.this.checkOpeness();
            ODatabaseDocumentTx.this.checkIfActive();
            if (!this.topLevel) {
                this.nestedCommit.complete();
                return null;
            }
            try {
                this.nestedCommit.complete();
            }
            catch (RuntimeException e) {
                OLogManager.instance().debug((Object)this, "Error on transaction commit", e, new Object[0]);
                for (ODatabaseListener listener : ODatabaseDocumentTx.this.browseListeners()) {
                    try {
                        listener.onBeforeTxRollback(ODatabaseDocumentTx.this);
                    }
                    catch (Throwable t) {
                        OLogManager.instance().error((Object)this, "Error before transaction rollback", t, new Object[0]);
                    }
                }
                this.nestedCommit.rollback();
                ODatabaseDocumentTx.this.getLocalCache().clear();
                for (ODatabaseListener listener : ODatabaseDocumentTx.this.browseListeners()) {
                    try {
                        listener.onAfterTxRollback(ODatabaseDocumentTx.this);
                    }
                    catch (Throwable t) {
                        OLogManager.instance().error((Object)this, "Error after transaction rollback", t, new Object[0]);
                    }
                }
                throw e;
            }
            for (ODatabaseListener listener : ODatabaseDocumentTx.this.browseListeners()) {
                try {
                    listener.onAfterTxCommit(ODatabaseDocumentTx.this);
                }
                catch (Exception e) {
                    String message = "Error after the transaction has been committed. The transaction remains valid. The exception caught was on execution of " + listener.getClass() + ".onAfterTxCommit()";
                    OLogManager.instance().error((Object)this, message, e, new Object[0]);
                    throw OException.wrapException(new OTransactionBlockedException(message), e);
                }
            }
            return null;
        }

        @Override
        public void rollback() {
            ODatabaseDocumentTx.this.checkOpeness();
            ODatabaseDocumentTx.this.checkIfActive();
            if (!this.topLevel) {
                this.nestedCommit.rollback();
                return;
            }
            for (ODatabaseListener listener : ODatabaseDocumentTx.this.browseListeners()) {
                try {
                    listener.onBeforeTxRollback(ODatabaseDocumentTx.this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before transaction rollback", t, new Object[0]);
                }
            }
            this.nestedCommit.rollback();
            ODatabaseDocumentTx.this.getLocalCache().clear();
            for (ODatabaseListener listener : ODatabaseDocumentTx.this.browseListeners()) {
                try {
                    listener.onAfterTxRollback(ODatabaseDocumentTx.this);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after transaction rollback", t, new Object[0]);
                }
            }
        }
    }

    public static final class LatestVersionRecordReader
    implements RecordReader {
        @Override
        public ORawBuffer readRecord(OStorage storage, ORecordId rid, String fetchPlan, boolean ignoreCache, int recordVersion) throws ORecordNotFoundException {
            return storage.readRecordIfVersionIsNotLatest(rid, fetchPlan, ignoreCache, recordVersion).getResult();
        }
    }

    public static final class SimpleRecordReader
    implements RecordReader {
        @Override
        public ORawBuffer readRecord(OStorage storage, ORecordId rid, String fetchPlan, boolean ignoreCache, int recordVersion) throws ORecordNotFoundException {
            return storage.readRecord(rid, fetchPlan, ignoreCache, null).getResult();
        }
    }

    public static interface RecordReader {
        public ORawBuffer readRecord(OStorage var1, ORecordId var2, String var3, boolean var4, int var5) throws ORecordNotFoundException;
    }
}

