/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaxrs.btm;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.LoggingReporter;
import com.github.kristofa.brave.Sampler;
import java.util.UUID;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;
import org.wildfly.swarm.spi.api.annotations.DeploymentModules;
import zipkin.reporter.AsyncReporter;
import zipkin.reporter.Reporter;
import zipkin.reporter.Sender;
import zipkin.reporter.urlconnection.URLConnectionSender;

@DeploymentModules(value={@DeploymentModule(name="com.fasterxml.jackson.jaxrs.jackson-jaxrs-json-provider"), @DeploymentModule(name="io.zipkin.brave"), @DeploymentModule(name="org.wildfly.swarm.jaxrs.btm")})
public class ZipkinFraction
implements Fraction<ZipkinFraction> {
    @AttributeDocumentation(value="The service name used in reports")
    private Defaultable<String> name = Defaultable.string((String)UUID.randomUUID().toString());
    @AttributeDocumentation(value="URL of the Zipkin server")
    private Defaultable<String> url = Defaultable.string((String)"http://localhost:9411/");
    @AttributeDocumentation(value="The reporting rate")
    private Defaultable<Float> rate = Defaultable.floating((float)1.0f);

    public ZipkinFraction() {
    }

    public ZipkinFraction(String name) {
        this.setName(name);
    }

    public Brave getBraveInstance() {
        Brave.Builder builder = new Brave.Builder((String)this.name.get());
        if (this.url.isDefault()) {
            builder.reporter((Reporter)new LoggingReporter()).traceSampler(Sampler.create((float)1.0f));
        } else {
            AsyncReporter asyncReporter = AsyncReporter.builder((Sender)URLConnectionSender.create((String)((String)this.url.get()))).build();
            builder.reporter((Reporter)asyncReporter).traceSampler(Sampler.create((float)((Float)this.rate.get()).floatValue()));
        }
        return builder.build();
    }

    public ZipkinFraction setName(String name) {
        this.name.set((Object)name);
        return this;
    }

    public ZipkinFraction setUrl(String url) {
        this.url.set((Object)url);
        return this;
    }

    public ZipkinFraction setRate(Float rate) {
        this.rate.set((Object)rate);
        return this;
    }
}

