/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.orientdb.runtime;

import javax.enterprise.context.ApplicationScoped;
import org.wildfly.swarm.config.orientdb.Orient;
import org.wildfly.swarm.container.util.DriverModuleBuilder;
import org.wildfly.swarm.container.util.Messages;
import org.wildfly.swarm.orientdb.OrientDBFraction;

@ApplicationScoped
public class OrientDBDriverInfo
extends DriverModuleBuilder {
    public OrientDBDriverInfo() {
        super("OrientDB", "com.orientechnologies.orient.core.db.OPartitionedDatabasePool", new String[]{"com.google.common.util.concurrent.AsyncFunction", "com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap", "com.tinkerpop.blueprints.Graph", "com.tinkerpop.blueprints.impls.orient.OrientVertex", "com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx", "com.orientechnologies.orient.client.remote.ORemoteConnectionPool", "com.orientechnologies.orient.object.db.OObjectDatabaseTx", "com.orientechnologies.orient.server.distributed.impl.task.OSyncClusterTask"}, new String[]{"javax.api", "org.picketbox", "sun.jdk", "org.slf4j", "javax.transaction.api"});
    }

    public boolean detect(OrientDBFraction fraction) {
        if (0 == fraction.subresources().orients().size()) {
            return false;
        }
        String moduleName = ((Orient)fraction.subresources().orients().get(0)).module() != null ? ((Orient)fraction.subresources().orients().get(0)).module() : "com.orientechnologies";
        fraction.subresources().orients().forEach(orient -> {
            if (orient.module() != null && !moduleName.equals(orient.module())) {
                throw Messages.MESSAGES.cannotAddReferenceToModule(orient.module(), moduleName);
            }
        });
        return super.detect(moduleName);
    }
}

