/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.metadatatable;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.RowMapper;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;

public class MetaDataTableImpl
implements MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTableImpl.class);
    private final DbSupport dbSupport;
    private final Table table;
    private final JdbcTemplate jdbcTemplate;
    private final LinkedList<AppliedMigration> cache = new LinkedList();
    private String installedBy;

    public MetaDataTableImpl(DbSupport dbSupport, Table table, String installedBy) {
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.dbSupport = dbSupport;
        this.table = table;
        this.installedBy = installedBy == null ? dbSupport.getCurrentUserFunction() : "'" + installedBy + "'";
    }

    @Override
    public boolean upgradeIfNecessary() {
        if (this.table.exists() && this.table.hasColumn("version_rank")) {
            new TransactionTemplate(this.jdbcTemplate.getConnection()).execute(new Callable<Object>(){

                @Override
                public Void call() {
                    MetaDataTableImpl.this.lock(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            LOG.info("Upgrading metadata table " + MetaDataTableImpl.this.table + " to the Flyway 4.0 format ...");
                            String resourceName = "org/flywaydb/core/internal/dbsupport/" + MetaDataTableImpl.this.dbSupport.getDbName() + "/upgradeMetaDataTable.sql";
                            String source = new ClassPathResource(resourceName, this.getClass().getClassLoader()).loadAsString("UTF-8");
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("schema", MetaDataTableImpl.this.table.getSchema().getName());
                            placeholders.put("table", MetaDataTableImpl.this.table.getName());
                            String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
                            SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, MetaDataTableImpl.this.dbSupport);
                            sqlScript.execute(MetaDataTableImpl.this.jdbcTemplate);
                            return null;
                        }
                    });
                    return null;
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public boolean exists() {
        return this.table.exists();
    }

    private void createIfNotExists() {
        int retries = 0;
        while (!this.table.exists()) {
            if (retries == 0) {
                LOG.info("Creating Metadata table: " + this.table);
            }
            try {
                String resourceName = "org/flywaydb/core/internal/dbsupport/" + this.dbSupport.getDbName() + "/createMetaDataTable.sql";
                String source = new ClassPathResource(resourceName, this.getClass().getClassLoader()).loadAsString("UTF-8");
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("schema", this.table.getSchema().getName());
                placeholders.put("table", this.table.getName());
                String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
                SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
                sqlScript.execute(this.jdbcTemplate);
                LOG.debug("Metadata table " + this.table + " created.");
            }
            catch (FlywayException e) {
                if (++retries >= 10) {
                    throw e;
                }
                try {
                    LOG.debug("Metadata table creation failed. Retrying in 1 sec ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public <T> T lock(Callable<T> callable) {
        this.createIfNotExists();
        return this.dbSupport.lock(this.table, callable);
    }

    @Override
    public void addAppliedMigration(AppliedMigration appliedMigration) {
        this.dbSupport.changeCurrentSchemaTo(this.table.getSchema());
        this.createIfNotExists();
        MigrationVersion version = appliedMigration.getVersion();
        try {
            String versionStr = version == null ? null : version.toString();
            String resourceName = "org/flywaydb/core/internal/dbsupport/" + this.dbSupport.getDbName() + "/updateMetaDataTable.sql";
            ClassPathResource classPathResource = new ClassPathResource(resourceName, this.getClass().getClassLoader());
            int installedRank = this.calculateInstalledRank();
            if (classPathResource.exists()) {
                String source = classPathResource.loadAsString("UTF-8");
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("schema", this.table.getSchema().getName());
                placeholders.put("table", this.table.getName());
                placeholders.put("installed_rank_val", String.valueOf(installedRank));
                placeholders.put("version_val", versionStr);
                placeholders.put("description_val", appliedMigration.getDescription());
                placeholders.put("type_val", appliedMigration.getType().name());
                placeholders.put("script_val", appliedMigration.getScript());
                placeholders.put("checksum_val", String.valueOf(appliedMigration.getChecksum()));
                placeholders.put("installed_by_val", this.installedBy);
                placeholders.put("execution_time_val", String.valueOf((long)appliedMigration.getExecutionTime() * 1000L));
                placeholders.put("success_val", String.valueOf(appliedMigration.isSuccess()));
                String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
                SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
                sqlScript.execute(this.jdbcTemplate);
            } else {
                this.jdbcTemplate.update("INSERT INTO " + this.table + " (" + this.dbSupport.quote("installed_rank") + "," + this.dbSupport.quote("version") + "," + this.dbSupport.quote("description") + "," + this.dbSupport.quote("type") + "," + this.dbSupport.quote("script") + "," + this.dbSupport.quote("checksum") + "," + this.dbSupport.quote("installed_by") + "," + this.dbSupport.quote("execution_time") + "," + this.dbSupport.quote("success") + ")" + " VALUES (?, ?, ?, ?, ?, ?, " + this.installedBy + ", ?, ?)", installedRank, versionStr, appliedMigration.getDescription(), appliedMigration.getType().name(), appliedMigration.getScript(), appliedMigration.getChecksum(), appliedMigration.getExecutionTime(), appliedMigration.isSuccess());
            }
            LOG.debug("MetaData table " + this.table + " successfully updated to reflect changes");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to insert row for version '" + version + "' in metadata table " + this.table, e);
        }
    }

    private int calculateInstalledRank() throws SQLException {
        int currentMax = this.jdbcTemplate.queryForInt("SELECT MAX(" + this.dbSupport.quote("installed_rank") + ")" + " FROM " + this.table, new String[0]);
        return currentMax + 1;
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        return this.findAppliedMigrations(new MigrationType[0]);
    }

    private List<AppliedMigration> findAppliedMigrations(MigrationType ... migrationTypes) {
        if (!this.table.exists()) {
            return new ArrayList<AppliedMigration>();
        }
        this.createIfNotExists();
        int minInstalledRank = this.cache.isEmpty() ? -1 : this.cache.getLast().getInstalledRank();
        String query = "SELECT " + this.dbSupport.quote("installed_rank") + "," + this.dbSupport.quote("version") + "," + this.dbSupport.quote("description") + "," + this.dbSupport.quote("type") + "," + this.dbSupport.quote("script") + "," + this.dbSupport.quote("checksum") + "," + this.dbSupport.quote("installed_on") + "," + this.dbSupport.quote("installed_by") + "," + this.dbSupport.quote("execution_time") + "," + this.dbSupport.quote("success") + " FROM " + this.table + " WHERE " + this.dbSupport.quote("installed_rank") + " > " + minInstalledRank;
        if (migrationTypes.length > 0) {
            query = query + " AND " + this.dbSupport.quote("type") + " IN (";
            for (int i = 0; i < migrationTypes.length; ++i) {
                if (i > 0) {
                    query = query + ",";
                }
                query = query + "'" + (Object)((Object)migrationTypes[i]) + "'";
            }
            query = query + ")";
        }
        query = query + " ORDER BY " + this.dbSupport.quote("installed_rank");
        try {
            this.cache.addAll(this.jdbcTemplate.query(query, new RowMapper<AppliedMigration>(){

                @Override
                public AppliedMigration mapRow(ResultSet rs) throws SQLException {
                    Integer checksum = rs.getInt("checksum");
                    if (rs.wasNull()) {
                        checksum = null;
                    }
                    return new AppliedMigration(rs.getInt("installed_rank"), rs.getString("version") != null ? MigrationVersion.fromVersion(rs.getString("version")) : null, rs.getString("description"), MigrationType.valueOf(rs.getString("type")), rs.getString("script"), checksum, rs.getTimestamp("installed_on"), rs.getString("installed_by"), rs.getInt("execution_time"), rs.getBoolean("success"));
                }
            }));
            return this.cache;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while retrieving the list of applied migrations from metadata table " + this.table, e);
        }
    }

    @Override
    public void addBaselineMarker(MigrationVersion baselineVersion, String baselineDescription) {
        this.addAppliedMigration(new AppliedMigration(baselineVersion, baselineDescription, MigrationType.BASELINE, baselineDescription, null, 0, true));
    }

    @Override
    public void removeFailedMigrations() {
        if (!this.table.exists()) {
            LOG.info("Repair of failed migration in metadata table " + this.table + " not necessary. No failed migration detected.");
            return;
        }
        this.createIfNotExists();
        try {
            int failedCount = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("success") + "=" + this.dbSupport.getBooleanFalse(), new String[0]);
            if (failedCount == 0) {
                LOG.info("Repair of failed migration in metadata table " + this.table + " not necessary. No failed migration detected.");
                return;
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to check the metadata table " + this.table + " for failed migrations", e);
        }
        try {
            this.jdbcTemplate.execute("DELETE FROM " + this.table + " WHERE " + this.dbSupport.quote("success") + " = " + this.dbSupport.getBooleanFalse(), new Object[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to repair metadata table " + this.table, e);
        }
    }

    @Override
    public void addSchemasMarker(Schema[] schemas) {
        this.createIfNotExists();
        this.addAppliedMigration(new AppliedMigration(null, "<< Flyway Schema Creation >>", MigrationType.SCHEMA, StringUtils.arrayToCommaDelimitedString(schemas), null, 0, true));
    }

    @Override
    public boolean hasSchemasMarker() {
        if (!this.table.exists()) {
            return false;
        }
        this.createIfNotExists();
        try {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("type") + "='SCHEMA'", new String[0]);
            return count > 0;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to check whether the metadata table " + this.table + " has a schema marker migration", e);
        }
    }

    @Override
    public boolean hasBaselineMarker() {
        if (!this.table.exists()) {
            return false;
        }
        this.createIfNotExists();
        try {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("type") + "='INIT' OR " + this.dbSupport.quote("type") + "='BASELINE'", new String[0]);
            return count > 0;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to check whether the metadata table " + this.table + " has an baseline marker migration", e);
        }
    }

    @Override
    public AppliedMigration getBaselineMarker() {
        List<AppliedMigration> appliedMigrations = this.findAppliedMigrations(MigrationType.BASELINE);
        return appliedMigrations.isEmpty() ? null : appliedMigrations.get(0);
    }

    @Override
    public boolean hasAppliedMigrations() {
        if (!this.table.exists()) {
            return false;
        }
        this.createIfNotExists();
        try {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("type") + " NOT IN ('SCHEMA', 'INIT', 'BASELINE')", new String[0]);
            return count > 0;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to check whether the metadata table " + this.table + " has applied migrations", e);
        }
    }

    @Override
    public void update(MigrationVersion version, String description, Integer checksum) {
        this.clearCache();
        LOG.info("Repairing metadata for version " + version + " (Description: " + description + ", Checksum: " + checksum + ")  ...");
        String resourceName = "org/flywaydb/core/internal/dbsupport/" + this.dbSupport.getDbName() + "/update.sql";
        ClassPathResource resource = new ClassPathResource(resourceName, this.getClass().getClassLoader());
        if (resource.exists()) {
            String source = resource.loadAsString("UTF-8");
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("schema", this.table.getSchema().getName());
            placeholders.put("table", this.table.getName());
            placeholders.put("version_val", version.toString());
            placeholders.put("description_val", description);
            placeholders.put("checksum_val", String.valueOf(checksum));
            String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
            new SqlScript(sourceNoPlaceholders, this.dbSupport).execute(this.jdbcTemplate);
        } else {
            try {
                this.jdbcTemplate.update("UPDATE " + this.table + " SET " + this.dbSupport.quote("description") + "='" + description + "' , " + this.dbSupport.quote("checksum") + "=" + checksum + " WHERE " + this.dbSupport.quote("version") + "='" + version + "'", new Object[0]);
            }
            catch (SQLException e) {
                throw new FlywaySqlException("Unable to repair metadata table " + this.table + " for version " + version, e);
            }
        }
    }

    public String toString() {
        return this.table.toString();
    }
}

