/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.tool.ODatabaseTool;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Iterator;
import java.util.List;

public class ODatabaseRepair
extends ODatabaseTool {
    private boolean removeBrokenLinks = true;

    @Override
    protected void parseSetting(String option, List<String> items) {
        if (option.equalsIgnoreCase("-excludeAll")) {
            this.removeBrokenLinks = false;
        } else if (option.equalsIgnoreCase("-removeBrokenLinks")) {
            this.removeBrokenLinks = Boolean.parseBoolean(items.get(0));
        }
    }

    @Override
    public void run() {
        long errors = 0L;
        if (this.removeBrokenLinks) {
            errors += this.removeBrokenLinks();
        }
        this.message("\nRepair database complete (" + errors + " errors)", new Object[0]);
    }

    protected long removeBrokenLinks() {
        long fixedLinks = 0L;
        long modifiedDocuments = 0L;
        long errors = 0L;
        this.message("\n- Removing broken links...", new Object[0]);
        for (String clusterName : this.database.getClusterNames()) {
            for (ORecord rec : this.database.browseCluster(clusterName)) {
                try {
                    if (!(rec instanceof ODocument)) continue;
                    boolean changed = false;
                    ODocument doc = (ODocument)rec;
                    for (String fieldName : doc.fieldNames()) {
                        Object fieldValue = doc.rawField(fieldName);
                        if (fieldValue instanceof OIdentifiable) {
                            if (!this.fixLink(fieldValue)) continue;
                            doc.field(fieldName, (Object)null);
                            ++fixedLinks;
                            changed = true;
                            if (!this.verbose) continue;
                            this.message("\n--- reset link " + ((OIdentifiable)fieldValue).getIdentity() + " in field '" + fieldName + "' (rid=" + doc.getIdentity() + ")", new Object[0]);
                            continue;
                        }
                        if (!(fieldValue instanceof Iterable)) continue;
                        if (fieldValue instanceof ORecordLazyMultiValue) {
                            ((ORecordLazyMultiValue)fieldValue).setAutoConvertToRecord(false);
                        }
                        Iterator it = ((Iterable)fieldValue).iterator();
                        int i = 0;
                        while (it.hasNext()) {
                            Object v = it.next();
                            if (this.fixLink(v)) {
                                it.remove();
                                ++fixedLinks;
                                changed = true;
                                if (this.verbose) {
                                    this.message("\n--- reset link " + ((OIdentifiable)v).getIdentity() + " as item " + i + " in collection of field '" + fieldName + "' (rid=" + doc.getIdentity() + ")", new Object[0]);
                                }
                            }
                            ++i;
                        }
                    }
                    if (!changed) continue;
                    ++modifiedDocuments;
                    doc.save();
                    if (!this.verbose) continue;
                    this.message("\n-- updated document " + doc.getIdentity(), new Object[0]);
                }
                catch (Exception e) {
                    ++errors;
                }
            }
        }
        this.message("\n-- Done! Fixed links: " + fixedLinks + ", modified documents: " + modifiedDocuments, new Object[0]);
        return errors;
    }

    protected boolean fixLink(Object fieldValue) {
        if (fieldValue instanceof OIdentifiable) {
            ORID id = ((OIdentifiable)fieldValue).getIdentity();
            if (id.getClusterId() == 0 && id.getClusterPosition() == 0L) {
                return true;
            }
            if (id.isValid()) {
                if (id.isPersistent()) {
                    Object connected = ((OIdentifiable)fieldValue).getRecord();
                    if (connected == null) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }
}

