/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.fluentd.logger.FluentLogger;
import org.fluentd.logger.sender.ExponentialDelayReconnector;
import org.fluentd.logger.sender.RawSocketSender;
import org.fluentd.logger.sender.Reconnector;
import org.fluentd.logger.sender.Sender;

public class FluentLoggerFactory {
    private final Map<FluentLogger, String> loggers = new WeakHashMap<FluentLogger, String>();

    public FluentLogger getLogger(String tagPrefix) {
        return this.getLogger(tagPrefix, "localhost", 24224);
    }

    public FluentLogger getLogger(String tagPrefix, String host, int port) {
        return this.getLogger(tagPrefix, host, port, 3000, 0x100000, new ExponentialDelayReconnector());
    }

    public FluentLogger getLogger(String tagPrefix, String host, int port, int timeout, int bufferCapacity) {
        return this.getLogger(tagPrefix, host, port, timeout, bufferCapacity, new ExponentialDelayReconnector());
    }

    public synchronized FluentLogger getLogger(String tagPrefix, String host, int port, int timeout, int bufferCapacity, Reconnector reconnector) {
        String key = String.format("%s_%s_%d_%d_%d", tagPrefix, host, port, timeout, bufferCapacity);
        for (Map.Entry<FluentLogger, String> entry : this.loggers.entrySet()) {
            if (!entry.getValue().equals(key)) continue;
            FluentLogger found = entry.getKey();
            if (found == null) break;
            return found;
        }
        Sender sender = null;
        Properties props = System.getProperties();
        if (!props.containsKey("fluentd.logger.sender.class")) {
            sender = new RawSocketSender(host, port, timeout, bufferCapacity, reconnector);
        } else {
            String senderClassName = props.getProperty("fluentd.logger.sender.class");
            try {
                sender = this.createSenderInstance(senderClassName, new Object[]{host, port, timeout, bufferCapacity});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FluentLogger logger = new FluentLogger(tagPrefix, sender);
        this.loggers.put(logger, key);
        return logger;
    }

    private Sender createSenderInstance(String className, Object[] params) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cl = FluentLogger.class.getClassLoader().loadClass(className);
        Constructor<?> cons = cl.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        return (Sender)cons.newInstance(params);
    }

    Map<FluentLogger, String> getLoggers() {
        return this.loggers;
    }

    public synchronized void closeAll() {
        for (FluentLogger logger : this.loggers.keySet()) {
            logger.close();
        }
        this.loggers.clear();
    }

    public synchronized void flushAll() {
        for (FluentLogger logger : this.loggers.keySet()) {
            logger.flush();
        }
    }
}

