/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;

public class StringFactory {
    public static final String V = "v";
    public static final String E = "e";
    public static final String L_BRACKET = "[";
    public static final String R_BRACKET = "]";
    public static final String DASH = "-";
    public static final String ARROW = "->";
    public static final String COLON = ":";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String EMPTY_STRING = "";

    public static String vertexString(Vertex vertex) {
        return "v[" + vertex.getId() + R_BRACKET;
    }

    public static String edgeString(Edge edge) {
        return "e[" + edge.getId() + R_BRACKET + L_BRACKET + edge.getVertex(Direction.OUT).getId() + DASH + edge.getLabel() + ARROW + edge.getVertex(Direction.IN).getId() + R_BRACKET;
    }

    public static String graphString(Graph graph, String internalString) {
        return graph.getClass().getSimpleName().toLowerCase() + L_BRACKET + internalString + R_BRACKET;
    }

    public static String indexString(Index index) {
        return "index[" + index.getIndexName() + COLON + index.getIndexClass().getSimpleName() + R_BRACKET;
    }
}

