/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;

public class ClientProducerCreditsImpl
implements ClientProducerCredits {
    private final Semaphore semaphore;
    private final int windowSize;
    private volatile boolean closed;
    private boolean blocked;
    private final SimpleString address;
    private final ClientSessionInternal session;
    private int pendingCredits;
    private int arriving;
    private int refCount;
    private boolean serverRespondedWithFail;
    private SessionContext sessionContext;

    public ClientProducerCreditsImpl(ClientSessionInternal session, SimpleString address, int windowSize) {
        this.session = session;
        this.address = address;
        this.windowSize = windowSize / 2;
        this.semaphore = new Semaphore(0, false);
    }

    @Override
    public void init(SessionContext sessionContext) {
        this.checkCredits(this.windowSize);
        this.sessionContext = sessionContext;
        this.sessionContext.linkFlowControl(this.address, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireCredits(int credits) throws ActiveMQException {
        boolean tryAcquire;
        this.checkCredits(credits);
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            tryAcquire = this.semaphore.tryAcquire(credits);
        }
        if (!tryAcquire && !this.closed) {
            this.blocked = true;
            try {
                while (!this.semaphore.tryAcquire(credits, 10L, TimeUnit.SECONDS)) {
                    ActiveMQClientLogger.LOGGER.outOfCreditOnFlowControl("" + this.address);
                }
            }
            catch (InterruptedException interrupted) {
                Thread.currentThread().interrupt();
                throw new ActiveMQInterruptedException((Throwable)interrupted);
            }
            finally {
                this.blocked = false;
            }
        }
        clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            this.pendingCredits -= credits;
        }
        clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            if (this.serverRespondedWithFail) {
                this.serverRespondedWithFail = false;
                this.semaphore.drainPermits();
                this.pendingCredits = 0;
                this.arriving = 0;
                throw ActiveMQClientMessageBundle.BUNDLE.addressIsFull(this.address.toString(), credits);
            }
        }
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    public int getBalance() {
        return this.semaphore.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveCredits(int credits) {
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            this.arriving -= credits;
        }
        this.semaphore.release(credits);
    }

    @Override
    public void receiveFailCredits(int credits) {
        this.serverRespondedWithFail = true;
        this.receiveCredits(credits);
    }

    @Override
    public synchronized void reset() {
        this.semaphore.drainPermits();
        int beforeFailure = this.pendingCredits;
        this.pendingCredits = 0;
        this.arriving = 0;
        this.checkCredits(Math.max(this.windowSize * 2, beforeFailure));
    }

    @Override
    public void close() {
        this.closed = true;
        this.semaphore.release(0x3FFFFFFF);
    }

    @Override
    public synchronized void incrementRefCount() {
        ++this.refCount;
    }

    @Override
    public synchronized int decrementRefCount() {
        return --this.refCount;
    }

    @Override
    public synchronized void releaseOutstanding() {
        this.semaphore.drainPermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCredits(int credits) {
        int needed = Math.max(credits, this.windowSize);
        int toRequest = -1;
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            if (this.semaphore.availablePermits() + this.arriving < needed) {
                toRequest = needed - this.arriving;
                this.pendingCredits += toRequest;
                this.arriving += toRequest;
            }
        }
        if (toRequest != -1) {
            this.requestCredits(toRequest);
        }
    }

    private void requestCredits(int credits) {
        this.session.sendProducerCreditsMessage(credits, this.address);
    }
}

