/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.Tracer;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.NullStatsReporter;
import com.uber.jaeger.metrics.StatsFactory;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.reporters.CompositeReporter;
import com.uber.jaeger.reporters.LoggingReporter;
import com.uber.jaeger.reporters.RemoteReporter;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.samplers.HttpSamplingManager;
import com.uber.jaeger.samplers.ProbabilisticSampler;
import com.uber.jaeger.samplers.RateLimitingSampler;
import com.uber.jaeger.samplers.RemoteControlledSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.senders.Sender;
import com.uber.jaeger.senders.UdpSender;
import java.text.NumberFormat;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final double DEFAULT_SAMPLING_PROBABILITY = 0.001;
    public static final String JAEGER_PREFIX = "JAEGER_";
    public static final String JAEGER_AGENT_HOST = "JAEGER_AGENT_HOST";
    public static final String JAEGER_AGENT_PORT = "JAEGER_AGENT_PORT";
    public static final String JAEGER_REPORTER_LOG_SPANS = "JAEGER_REPORTER_LOG_SPANS";
    public static final String JAEGER_REPORTER_MAX_QUEUE_SIZE = "JAEGER_REPORTER_MAX_QUEUE_SIZE";
    public static final String JAEGER_REPORTER_FLUSH_INTERVAL = "JAEGER_REPORTER_FLUSH_INTERVAL";
    public static final String JAEGER_SAMPLER_TYPE = "JAEGER_SAMPLER_TYPE";
    public static final String JAEGER_SAMPLER_PARAM = "JAEGER_SAMPLER_PARAM";
    public static final String JAEGER_SAMPLER_MANAGER_HOST_PORT = "JAEGER_SAMPLER_MANAGER_HOST_PORT";
    public static final String JAEGER_SERVICE_NAME = "JAEGER_SERVICE_NAME";
    private final String serviceName;
    private final SamplerConfiguration samplerConfig;
    private final ReporterConfiguration reporterConfig;
    private StatsFactory statsFactory;
    private Tracer tracer;

    public Configuration(String serviceName) {
        this(serviceName, null, null);
    }

    public Configuration(String serviceName, SamplerConfiguration samplerConfig, ReporterConfiguration reporterConfig) {
        if (serviceName == null || serviceName.isEmpty()) {
            throw new IllegalArgumentException("Must provide a service name for Jaeger Configuration");
        }
        this.serviceName = serviceName;
        if (samplerConfig == null) {
            samplerConfig = new SamplerConfiguration(null, null, null);
        }
        this.samplerConfig = samplerConfig;
        if (reporterConfig == null) {
            reporterConfig = new ReporterConfiguration(null, null, null, null, null);
        }
        this.reporterConfig = reporterConfig;
        this.statsFactory = new StatsFactoryImpl(new NullStatsReporter());
    }

    public static Configuration fromEnv() {
        return new Configuration(Configuration.getProperty(JAEGER_SERVICE_NAME), SamplerConfiguration.fromEnv(), ReporterConfiguration.fromEnv());
    }

    public Tracer.Builder getTracerBuilder() {
        Metrics metrics = new Metrics(this.statsFactory);
        Reporter reporter = this.reporterConfig.getReporter(metrics);
        Sampler sampler = this.samplerConfig.createSampler(this.serviceName, metrics);
        return new Tracer.Builder(this.serviceName, reporter, sampler).withMetrics(metrics);
    }

    public synchronized io.opentracing.Tracer getTracer() {
        if (this.tracer != null) {
            return this.tracer;
        }
        this.tracer = this.getTracerBuilder().build();
        log.info("Initialized tracer={}", (Object)this.tracer);
        return this.tracer;
    }

    public synchronized void closeTracer() {
        if (this.tracer != null) {
            this.tracer.close();
        }
    }

    @Deprecated
    public void setStatsFactor(StatsFactory statsFactory) {
        this.statsFactory = statsFactory;
    }

    public void setStatsFactory(StatsFactory statsFactory) {
        this.statsFactory = statsFactory;
    }

    private static String stringOrDefault(String value, String defaultValue) {
        return value != null && value.length() > 0 ? value : defaultValue;
    }

    private static Number numberOrDefault(Number value, Number defaultValue) {
        return value != null ? (Number)value : (Number)defaultValue;
    }

    private static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    private static Integer getPropertyAsInt(String name) {
        String value = Configuration.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse integer for property '" + name + "' with value '" + value + "'", (Throwable)e);
            }
        }
        return null;
    }

    private static Number getPropertyAsNum(String name) {
        String value = Configuration.getProperty(name);
        if (value != null) {
            try {
                return NumberFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                log.error("Failed to parse number for property '" + name + "' with value '" + value + "'", (Throwable)e);
            }
        }
        return null;
    }

    private static Boolean getPropertyAsBoolean(String name) {
        String value = Configuration.getProperty(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static class ReporterConfiguration {
        private static final int DEFAULT_FLUSH_INTERVAL_MS = 1000;
        private static final int DEFAULT_MAX_QUEUE_SIZE = 100;
        private Boolean logSpans;
        private String agentHost;
        private Integer agentPort;
        private Integer flushIntervalMs;
        private Integer maxQueueSize;
        private Sender sender;

        public ReporterConfiguration() {
            this(null, null, null, null, null);
        }

        public ReporterConfiguration(Sender sender) {
            this.sender = sender;
        }

        public ReporterConfiguration(Boolean logSpans, String agentHost, Integer agentPort, Integer flushIntervalMs, Integer maxQueueSize) {
            this.logSpans = logSpans;
            this.agentHost = agentHost;
            this.agentPort = agentPort;
            this.flushIntervalMs = flushIntervalMs;
            this.maxQueueSize = maxQueueSize;
        }

        public static ReporterConfiguration fromEnv() {
            return new ReporterConfiguration(Configuration.getPropertyAsBoolean(Configuration.JAEGER_REPORTER_LOG_SPANS), Configuration.getProperty(Configuration.JAEGER_AGENT_HOST), Configuration.getPropertyAsInt(Configuration.JAEGER_AGENT_PORT), Configuration.getPropertyAsInt(Configuration.JAEGER_REPORTER_FLUSH_INTERVAL), Configuration.getPropertyAsInt(Configuration.JAEGER_REPORTER_MAX_QUEUE_SIZE));
        }

        private Sender getSender() {
            return this.sender != null ? this.sender : new UdpSender(Configuration.stringOrDefault(this.agentHost, "localhost"), Configuration.numberOrDefault(this.agentPort, 6831).intValue(), 0);
        }

        private Reporter getReporter(Metrics metrics) {
            Reporter reporter = new RemoteReporter(this.getSender(), Configuration.numberOrDefault(this.flushIntervalMs, 1000).intValue(), Configuration.numberOrDefault(this.maxQueueSize, 100).intValue(), metrics);
            if (Boolean.TRUE.equals(this.logSpans)) {
                LoggingReporter loggingReporter = new LoggingReporter();
                reporter = new CompositeReporter(reporter, loggingReporter);
            }
            return reporter;
        }

        public Boolean getLogSpans() {
            return this.logSpans;
        }

        public String getAgentHost() {
            return this.agentHost;
        }

        public Integer getAgentPort() {
            return this.agentPort;
        }

        public Integer getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }
    }

    public static class SamplerConfiguration {
        private static final String defaultManagerHostPort = "localhost:5778";
        private final String type;
        private final Number param;
        private final String managerHostPort;

        public SamplerConfiguration(String type, Number param) {
            this(type, param, null);
        }

        public SamplerConfiguration() {
            this(null, null, null);
        }

        public SamplerConfiguration(String type, Number param, String managerHostPort) {
            this.type = type;
            this.param = param;
            this.managerHostPort = managerHostPort;
        }

        public static SamplerConfiguration fromEnv() {
            return new SamplerConfiguration(Configuration.getProperty(Configuration.JAEGER_SAMPLER_TYPE), Configuration.getPropertyAsNum(Configuration.JAEGER_SAMPLER_PARAM), Configuration.getProperty(Configuration.JAEGER_SAMPLER_MANAGER_HOST_PORT));
        }

        private Sampler createSampler(String serviceName, Metrics metrics) {
            String samplerType = Configuration.stringOrDefault(this.getType(), "remote");
            Number samplerParam = Configuration.numberOrDefault(this.getParam(), 0.001);
            String hostPort = Configuration.stringOrDefault(this.getManagerHostPort(), defaultManagerHostPort);
            if (samplerType.equals("const")) {
                return new ConstSampler(samplerParam.intValue() != 0);
            }
            if (samplerType.equals("probabilistic")) {
                return new ProbabilisticSampler(samplerParam.doubleValue());
            }
            if (samplerType.equals("ratelimiting")) {
                return new RateLimitingSampler(samplerParam.intValue());
            }
            if (samplerType.equals("remote")) {
                ProbabilisticSampler initialSampler = new ProbabilisticSampler(samplerParam.doubleValue());
                HttpSamplingManager manager = new HttpSamplingManager(hostPort);
                return new RemoteControlledSampler(serviceName, manager, initialSampler, metrics);
            }
            throw new IllegalStateException(String.format("Invalid sampling strategy %s", samplerType));
        }

        public String getType() {
            return this.type;
        }

        public Number getParam() {
            return this.param;
        }

        public String getManagerHostPort() {
            return this.managerHostPort;
        }
    }
}

