/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cassandra.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.cassandra.CassandraFraction;
import org.wildfly.swarm.cassandra.runtime.CassandraDriverInfo;
import org.wildfly.swarm.container.util.Messages;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@ApplicationScoped
public class CassandraCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<CassandraFraction> allDrivers;

    public void customize() throws Exception {
        this.customizeDrivers();
    }

    protected void customizeDrivers() {
        this.allDrivers.forEach(this::attemptInstallation);
    }

    protected void attemptInstallation(CassandraFraction info) {
        CassandraDriverInfo cassandraDriverInfo = new CassandraDriverInfo();
        if (cassandraDriverInfo.detect(info)) {
            Messages.MESSAGES.autodetectedDriver(cassandraDriverInfo.name());
        }
    }
}

