/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import zipkin.reporter.Reporter;

final class SpanCollectorReporterAdapter
implements SpanCollector,
Reporter<zipkin.Span> {
    final SpanCollector delegate;

    SpanCollectorReporterAdapter(SpanCollector delegate) {
        this.delegate = Util.checkNotNull(delegate, "span collector", new Object[0]);
    }

    public void report(zipkin.Span span) {
        Util.checkNotNull(span, "Null span", new Object[0]);
        this.collect(SpanCollectorReporterAdapter.toBrave(span));
    }

    @Override
    public void collect(Span span) {
        Util.checkNotNull(span, "Null span", new Object[0]);
        this.delegate.collect(span);
    }

    @Override
    @Deprecated
    public void addDefaultAnnotation(String key, String value) {
        this.delegate.addDefaultAnnotation(key, value);
    }

    static Span toBrave(zipkin.Span input) {
        Span result = new Span();
        result.setTrace_id(input.traceId);
        result.setId(input.id);
        result.setParent_id(input.parentId);
        result.setName(input.name);
        result.setTimestamp(input.timestamp);
        result.setDuration(input.duration);
        result.setDebug(input.debug);
        for (zipkin.Annotation a : input.annotations) {
            result.addToAnnotations(Annotation.create(a.timestamp, a.value, SpanCollectorReporterAdapter.from(a.endpoint)));
        }
        for (zipkin.Annotation a : input.binaryAnnotations) {
            result.addToBinary_annotations(BinaryAnnotation.create(a.key, a.value, AnnotationType.fromValue(a.type.value), SpanCollectorReporterAdapter.from(a.endpoint)));
        }
        return result;
    }

    private static Endpoint from(zipkin.Endpoint endpoint) {
        if (endpoint == null) {
            return null;
        }
        return Endpoint.builder().ipv4(endpoint.ipv4).ipv6(endpoint.ipv6).port(endpoint.port).serviceName(endpoint.serviceName).build();
    }
}

