/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.neo4j.runtime;

import javax.enterprise.context.ApplicationScoped;
import org.wildfly.swarm.config.neo4jdriver.Neo4j;
import org.wildfly.swarm.container.util.DriverModuleBuilder;
import org.wildfly.swarm.container.util.Messages;
import org.wildfly.swarm.neo4j.Neo4jFraction;

@ApplicationScoped
public class Neo4jDriverInfo
extends DriverModuleBuilder {
    public Neo4jDriverInfo() {
        super("Neo4j", "org.neo4j.driver.v1.Driver", new String[]{"org.neo4j.driver.v1.GraphDatabase", "org.wildfly.extension.nosql.cdi.Neo4jExtension", "org.neo4j.driver.v1.AuthTokens", "org.neo4j.driver.v1.AuthToken"}, new String[]{"javax.api", "org.picketbox"});
    }

    public boolean detect(Neo4jFraction fraction) {
        if (0 == fraction.subresources().neo4js().size()) {
            return false;
        }
        String moduleName = ((Neo4j)fraction.subresources().neo4js().get(0)).module() != null ? ((Neo4j)fraction.subresources().neo4js().get(0)).module() : "org.neo4j.driver";
        fraction.subresources().neo4js().forEach(neo4j -> {
            if (neo4j.module() != null && !moduleName.equals(neo4j.module())) {
                throw Messages.MESSAGES.cannotAddReferenceToModule(neo4j.module(), moduleName);
            }
        });
        return super.detect(moduleName);
    }
}

