/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spanmanager;

import io.opentracing.NoopSpan;
import io.opentracing.Span;
import io.opentracing.contrib.spanmanager.SpanManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DefaultSpanManager
implements SpanManager {
    private static final Logger LOGGER = Logger.getLogger(DefaultSpanManager.class.getName());
    private static final DefaultSpanManager INSTANCE = new DefaultSpanManager();
    private static final SpanManager.ManagedSpan NO_MANAGED_SPAN = new NoManagedSpan();
    private final ThreadLocal<LinkedManagedSpan> managed = new ThreadLocal();

    private DefaultSpanManager() {
    }

    public static SpanManager getInstance() {
        return INSTANCE;
    }

    private LinkedManagedSpan refreshCurrent() {
        LinkedManagedSpan managedSpan;
        LinkedManagedSpan current = managedSpan = this.managed.get();
        while (current != null && current.deactivated.get()) {
            current = current.parent;
        }
        if (current != managedSpan) {
            if (current == null) {
                this.managed.remove();
            } else {
                this.managed.set(current);
            }
        }
        return current;
    }

    @Override
    public SpanManager.ManagedSpan activate(Span span) {
        LinkedManagedSpan managedSpan = new LinkedManagedSpan(span, this.refreshCurrent());
        this.managed.set(managedSpan);
        return managedSpan;
    }

    @Override
    public SpanManager.ManagedSpan current() {
        LinkedManagedSpan current = this.refreshCurrent();
        return current != null ? current : NO_MANAGED_SPAN;
    }

    @Override
    public void clear() {
        this.managed.remove();
    }

    @Override
    @Deprecated
    public Span currentSpan() {
        SpanManager.ManagedSpan current = this.current();
        return current.getSpan() != null ? current.getSpan() : NoopSpan.INSTANCE;
    }

    @Deprecated
    public SpanManager.ManagedSpan manage(Span span) {
        return this.activate(span);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static final class NoManagedSpan
    implements SpanManager.ManagedSpan {
        private NoManagedSpan() {
        }

        @Override
        public Span getSpan() {
            return null;
        }

        @Override
        public void deactivate() {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private final class LinkedManagedSpan
    implements SpanManager.ManagedSpan {
        private final LinkedManagedSpan parent;
        private final Span span;
        private final AtomicBoolean deactivated = new AtomicBoolean(false);

        private LinkedManagedSpan(Span span, LinkedManagedSpan parent) {
            this.parent = parent;
            this.span = span;
        }

        @Override
        public Span getSpan() {
            return this.span;
        }

        @Override
        public void deactivate() {
            if (this.deactivated.compareAndSet(false, true)) {
                LinkedManagedSpan current = DefaultSpanManager.this.refreshCurrent();
                LOGGER.log(Level.FINER, "Released {0}, current span is {1}.", new Object[]{this, current});
            } else {
                LOGGER.log(Level.FINEST, "No action needed, {0} was already deactivated.", this);
            }
        }

        @Override
        public void close() {
            this.deactivate();
        }

        @Deprecated
        public void release() {
            this.deactivate();
        }

        public String toString() {
            return this.getClass().getSimpleName() + '{' + this.span + '}';
        }
    }
}

