/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spanmanager.concurrent;

import io.opentracing.Span;
import io.opentracing.contrib.spanmanager.SpanManager;
import java.util.concurrent.Callable;

final class CallableWithManagedSpan<T>
implements Callable<T> {
    private final Callable<T> delegate;
    private final SpanManager spanManager;
    private final Span spanToManage;

    CallableWithManagedSpan(Callable<T> callable, SpanManager spanManager, Span spanToManage) {
        if (callable == null) {
            throw new NullPointerException("Callable is <null>.");
        }
        if (spanManager == null) {
            throw new NullPointerException("Span manager is <null>.");
        }
        this.delegate = callable;
        this.spanManager = spanManager;
        this.spanToManage = spanToManage;
    }

    @Override
    public T call() throws Exception {
        SpanManager.ManagedSpan managedSpan = this.spanManager.activate(this.spanToManage);
        try {
            T t = this.delegate.call();
            return t;
        }
        finally {
            managedSpan.deactivate();
        }
    }
}

