/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spanmanager.concurrent;

import io.opentracing.Span;
import io.opentracing.contrib.spanmanager.SpanManager;
import io.opentracing.contrib.spanmanager.concurrent.CallableWithManagedSpan;
import io.opentracing.contrib.spanmanager.concurrent.RunnableWithManagedSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SpanPropagatingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;
    private final SpanManager spanManager;

    public SpanPropagatingExecutorService(ExecutorService delegate, SpanManager spanManager) {
        if (delegate == null) {
            throw new NullPointerException("Delegate executor service is <null>.");
        }
        if (spanManager == null) {
            throw new NullPointerException("SpanManager is <null>.");
        }
        this.delegate = delegate;
        this.spanManager = spanManager;
    }

    private Runnable runnableWithCurrentSpan(Runnable runnable, Span customCurrentSpan) {
        return new RunnableWithManagedSpan(runnable, this.spanManager, customCurrentSpan);
    }

    private <T> Callable<T> callableWithCurrentSpan(Callable<T> callable, Span customCurrentSpan) {
        return new CallableWithManagedSpan<T>(callable, this.spanManager, customCurrentSpan);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.runnableWithCurrentSpan(command, this.spanManager.current().getSpan()));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.runnableWithCurrentSpan(task, this.spanManager.current().getSpan()));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.runnableWithCurrentSpan(task, this.spanManager.current().getSpan()), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.callableWithCurrentSpan(task, this.spanManager.current().getSpan()));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.tasksWithCurrentSpan(tasks, this.spanManager.current().getSpan()));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.tasksWithCurrentSpan(tasks, this.spanManager.current().getSpan()), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.tasksWithCurrentSpan(tasks, this.spanManager.current().getSpan()));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.tasksWithCurrentSpan(tasks, this.spanManager.current().getSpan()), timeout, unit);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    private <T> Collection<? extends Callable<T>> tasksWithCurrentSpan(Collection<? extends Callable<T>> tasks, Span customCurrentSpan) {
        if (tasks == null) {
            throw new NullPointerException("Collection of tasks is <null>.");
        }
        ArrayList<Callable<T>> result = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            result.add(this.callableWithCurrentSpan(task, customCurrentSpan));
        }
        return result;
    }
}

