/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spanmanager.tracer;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.spanmanager.SpanManager;
import java.util.Map;

final class AutoReleasingManagedSpan
implements Span,
SpanManager.ManagedSpan {
    private final SpanManager.ManagedSpan managedSpan;

    AutoReleasingManagedSpan(SpanManager.ManagedSpan managedSpan) {
        if (managedSpan == null) {
            throw new NullPointerException("Managed span was <null>.");
        }
        this.managedSpan = managedSpan;
    }

    @Override
    public Span getSpan() {
        return this.managedSpan.getSpan();
    }

    @Override
    public void deactivate() {
        this.managedSpan.deactivate();
    }

    public void finish() {
        try {
            this.getSpan().finish();
        }
        finally {
            this.deactivate();
        }
    }

    public void finish(long finishMicros) {
        try {
            this.getSpan().finish(finishMicros);
        }
        finally {
            this.deactivate();
        }
    }

    @Override
    public void close() {
        try {
            this.getSpan().close();
        }
        finally {
            this.deactivate();
        }
    }

    public SpanContext context() {
        return this.getSpan().context();
    }

    public Span setTag(String key, String value) {
        this.getSpan().setTag(key, value);
        return this;
    }

    public Span setTag(String key, boolean value) {
        this.getSpan().setTag(key, value);
        return this;
    }

    public Span setTag(String key, Number value) {
        this.getSpan().setTag(key, value);
        return this;
    }

    public Span log(Map<String, ?> fields) {
        this.getSpan().log(fields);
        return this;
    }

    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        this.getSpan().log(timestampMicroseconds, fields);
        return this;
    }

    public Span log(String event) {
        this.getSpan().log(event);
        return this;
    }

    public Span log(long timestampMicroseconds, String event) {
        this.getSpan().log(timestampMicroseconds, event);
        return this;
    }

    public Span setBaggageItem(String key, String value) {
        this.getSpan().setBaggageItem(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.getSpan().getBaggageItem(key);
    }

    public Span setOperationName(String operationName) {
        this.getSpan().setOperationName(operationName);
        return this;
    }

    public Span log(String eventName, Object payload) {
        this.getSpan().log(eventName, payload);
        return this;
    }

    public Span log(long timestampMicroseconds, String eventName, Object payload) {
        this.getSpan().log(timestampMicroseconds, eventName, payload);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.managedSpan + '}';
    }
}

