/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.Arrays;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArgsPushNode
extends Node {
    private Node firstNode;
    private Node secondNode;

    public ArgsPushNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position);
        assert (firstNode != null) : "ArgsPushNode.first == null";
        assert (secondNode != null) : "ArgsPushNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSPUSHNODE;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visitArgsPushNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Arrays.asList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        RubyArray args2 = (RubyArray)this.firstNode.interpret(runtime, context, self2, aBlock).dup();
        return args2.append(this.secondNode.interpret(runtime, context, self2, aBlock));
    }
}

