/*
  *
  *  *  Copyright 2014 Orient Technologies LTD (info(at)orientechnologies.com)
  *  *
  *  *  Licensed under the Apache License, Version 2.0 (the "License");
  *  *  you may not use this file except in compliance with the License.
  *  *  You may obtain a copy of the License at
  *  *
  *  *       http://www.apache.org/licenses/LICENSE-2.0
  *  *
  *  *  Unless required by applicable law or agreed to in writing, software
  *  *  distributed under the License is distributed on an "AS IS" BASIS,
  *  *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  *  *  See the License for the specific language governing permissions and
  *  *  limitations under the License.
  *  *
  *  * For more information: http://www.orientechnologies.com
  *
  */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;

/**
 * EQUALS operator.
 * 
 * @author Luca Garulli
 * 
 */
public class OQueryOperatorInstanceof extends OQueryOperatorEqualityNotNulls {

	public OQueryOperatorInstanceof() {
		super("INSTANCEOF", 5, false);
	}

	@Override
	protected boolean evaluateExpression(final OIdentifiable iRecord, final OSQLFilterCondition iCondition, final Object iLeft,
			final Object iRight, OCommandContext iContext) {

		final OSchema schema = ((OMetadataInternal)ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata()).getImmutableSchemaSnapshot();

		final String baseClassName = iRight.toString();
		final OClass baseClass = schema.getClass(baseClassName);
		if (baseClass == null)
			throw new OCommandExecutionException("Class '" + baseClassName + "' is not defined in database schema");

		OClass cls = null;
		if (iLeft instanceof OIdentifiable) {
			// GET THE RECORD'S CLASS
			final ORecord record = ((OIdentifiable) iLeft).getRecord();
			if (record instanceof ODocument) {
				cls = ODocumentInternal.getImmutableSchemaClass(((ODocument) record));
			}
		} else if (iLeft instanceof String)
			// GET THE CLASS BY NAME
			cls = schema.getClass((String) iLeft);

		return cls != null ? cls.isSubClassOf(baseClass) : false;
	}

	@Override
	public OIndexReuseType getIndexReuseType(final Object iLeft, final Object iRight) {
		return OIndexReuseType.NO_INDEX;
	}

	@Override
	public ORID getBeginRidRange(Object iLeft, Object iRight) {
		return null;
	}

	@Override
	public ORID getEndRidRange(Object iLeft, Object iRight) {
		return null;
	}
}
