/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Features {
    public Boolean supportsDuplicateEdges = null;
    public Boolean supportsSelfLoops = null;
    public Boolean supportsSerializableObjectProperty = null;
    public Boolean supportsBooleanProperty = null;
    public Boolean supportsDoubleProperty = null;
    public Boolean supportsFloatProperty = null;
    public Boolean supportsIntegerProperty = null;
    public Boolean supportsPrimitiveArrayProperty = null;
    public Boolean supportsUniformListProperty = null;
    public Boolean supportsMixedListProperty = null;
    public Boolean supportsLongProperty = null;
    public Boolean supportsMapProperty = null;
    public Boolean supportsStringProperty = null;
    public Boolean hasImplicitElements = false;
    public Boolean ignoresSuppliedIds = null;
    public Boolean isPersistent = null;
    public Boolean isWrapper = null;
    public Boolean supportsIndices = null;
    public Boolean supportsVertexIndex = null;
    public Boolean supportsEdgeIndex = null;
    public Boolean supportsKeyIndices = null;
    public Boolean supportsVertexKeyIndex = null;
    public Boolean supportsEdgeKeyIndex = null;
    public Boolean supportsEdgeIteration = null;
    public Boolean supportsVertexIteration = null;
    public Boolean supportsEdgeRetrieval = null;
    public Boolean supportsVertexProperties = null;
    public Boolean supportsEdgeProperties = null;
    public Boolean supportsTransactions = null;
    public Boolean supportsThreadedTransactions = null;
    public Boolean supportsThreadIsolatedTransactions = null;

    public boolean supportsElementProperties() {
        return this.supportsVertexProperties != false && this.supportsEdgeProperties != false;
    }

    public String toString() {
        try {
            StringBuilder string = new StringBuilder();
            for (Field field : this.getClass().getFields()) {
                string.append(field.getName() + ": " + field.get(this).toString() + "\n");
            }
            return string.toString().substring(0, string.length() - 1);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Map toMap() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : this.getClass().getFields()) {
                map.put(field.getName(), field.get(this));
            }
            return Collections.unmodifiableMap(map);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void checkCompliance() throws IllegalStateException {
        try {
            for (Field field : this.getClass().getFields()) {
                if (field.get(this) != null) continue;
                throw new IllegalStateException("The feature " + field.getName() + " was not specified");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Features copyFeatures() {
        try {
            Features features = new Features();
            for (Field field : this.getClass().getFields()) {
                field.set(features, field.get(this));
            }
            return features;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

