/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.Reference;
import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.exceptions.UnsupportedFormatException;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.NullStatsReporter;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.metrics.StatsReporter;
import com.uber.jaeger.propagation.Extractor;
import com.uber.jaeger.propagation.Injector;
import com.uber.jaeger.propagation.TextMapCodec;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.samplers.SamplingStatus;
import com.uber.jaeger.utils.Clock;
import com.uber.jaeger.utils.SystemClock;
import com.uber.jaeger.utils.Utils;
import io.opentracing.ActiveSpan;
import io.opentracing.ActiveSpanSource;
import io.opentracing.BaseSpan;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.ThreadLocalActiveSpanSource;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracer
implements io.opentracing.Tracer {
    private static final Logger log = LoggerFactory.getLogger(Tracer.class);
    private final String version;
    private final String serviceName;
    private final Reporter reporter;
    private final Sampler sampler;
    private final PropagationRegistry registry;
    private final Clock clock;
    private final Metrics metrics;
    private final int ipv4;
    private final Map<String, ?> tags;
    private final boolean zipkinSharedRpcSpan;
    private final ActiveSpanSource activeSpanSource;

    private Tracer(String serviceName, Reporter reporter, Sampler sampler, PropagationRegistry registry, Clock clock, Metrics metrics, Map<String, Object> tags, boolean zipkinSharedRpcSpan, ActiveSpanSource activeSpanSource) {
        int ipv4;
        this.serviceName = serviceName;
        this.reporter = reporter;
        this.sampler = sampler;
        this.registry = registry;
        this.clock = clock;
        this.metrics = metrics;
        this.zipkinSharedRpcSpan = zipkinSharedRpcSpan;
        this.activeSpanSource = activeSpanSource;
        this.version = Tracer.loadVersion();
        tags.put("jaeger.version", this.version);
        String hostname = this.getHostName();
        if (hostname != null) {
            tags.put("hostname", hostname);
        }
        try {
            tags.put("ip", InetAddress.getLocalHost().getHostAddress());
            ipv4 = Utils.ipToInt(Inet4Address.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            ipv4 = 0;
        }
        this.ipv4 = ipv4;
        this.tags = Collections.unmodifiableMap(tags);
    }

    public String getVersion() {
        return this.version;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, ?> tags() {
        return this.tags;
    }

    public int getIpv4() {
        return this.ipv4;
    }

    Clock clock() {
        return this.clock;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    void reportSpan(Span span) {
        this.reporter.report(span);
        this.metrics.spansFinished.inc(1L);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    public <T> void inject(io.opentracing.SpanContext spanContext, Format<T> format, T carrier) {
        Injector<T> injector = this.registry.getInjector(format);
        if (injector == null) {
            throw new UnsupportedFormatException(format);
        }
        injector.inject((SpanContext)spanContext, carrier);
    }

    public <T> io.opentracing.SpanContext extract(Format<T> format, T carrier) {
        Extractor<T> extractor = this.registry.getExtractor(format);
        if (extractor == null) {
            throw new UnsupportedFormatException(format);
        }
        return extractor.extract(carrier);
    }

    public ActiveSpan activeSpan() {
        return this.activeSpanSource.activeSpan();
    }

    public ActiveSpan makeActive(io.opentracing.Span span) {
        return this.activeSpanSource.makeActive(span);
    }

    public void close() {
        this.reporter.close();
        this.sampler.close();
    }

    private static String loadVersion() {
        String version;
        try {
            InputStream is = Tracer.class.getResourceAsStream("jaeger.properties");
            try {
                Properties prop = new Properties();
                prop.load(is);
                version = prop.getProperty("jaeger.version");
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read jaeger.properties", e);
        }
        if (version == null) {
            throw new RuntimeException("Cannot read jaeger.version from jaeger.properties");
        }
        return "Java-" + version;
    }

    String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("Cannot obtain host name", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "Tracer(version=" + this.getVersion() + ", serviceName=" + this.getServiceName() + ", reporter=" + this.getReporter() + ", sampler=" + this.sampler + ", ipv4=" + this.getIpv4() + ", tags=" + this.tags + ", zipkinSharedRpcSpan=" + this.zipkinSharedRpcSpan + ")";
    }

    private static class PropagationRegistry {
        private final Map<Format<?>, Injector<?>> injectors = new HashMap();
        private final Map<Format<?>, Extractor<?>> extractors = new HashMap();

        private PropagationRegistry() {
        }

        <T> Injector<T> getInjector(Format<T> format) {
            return this.injectors.get(format);
        }

        <T> Extractor<T> getExtractor(Format<T> format) {
            return this.extractors.get(format);
        }

        public <T> void register(Format<T> format, Injector<T> injector) {
            this.injectors.put(format, injector);
        }

        public <T> void register(Format<T> format, Extractor<T> extractor) {
            this.extractors.put(format, extractor);
        }
    }

    public static final class Builder {
        private final Sampler sampler;
        private final Reporter reporter;
        private final PropagationRegistry registry = new PropagationRegistry();
        private Metrics metrics;
        private String serviceName;
        private Clock clock = new SystemClock();
        private Map<String, Object> tags = new HashMap<String, Object>();
        private boolean zipkinSharedRpcSpan;
        private ActiveSpanSource activeSpanSource = new ThreadLocalActiveSpanSource();

        public Builder(String serviceName, Reporter reporter, Sampler sampler) {
            if (serviceName == null || serviceName.trim().length() == 0) {
                throw new IllegalArgumentException("serviceName must not be null or empty");
            }
            this.serviceName = serviceName;
            this.reporter = reporter;
            this.sampler = sampler;
            this.metrics = new Metrics(new StatsFactoryImpl(new NullStatsReporter()));
            TextMapCodec textMapCodec = new TextMapCodec(false);
            this.registerInjector(Format.Builtin.TEXT_MAP, textMapCodec);
            this.registerExtractor(Format.Builtin.TEXT_MAP, textMapCodec);
            TextMapCodec httpCodec = new TextMapCodec(true);
            this.registerInjector(Format.Builtin.HTTP_HEADERS, httpCodec);
            this.registerExtractor(Format.Builtin.HTTP_HEADERS, httpCodec);
        }

        public <T> Builder registerInjector(Format<T> format, Injector<T> injector) {
            this.registry.register(format, injector);
            return this;
        }

        public <T> Builder registerExtractor(Format<T> format, Extractor<T> extractor) {
            this.registry.register(format, extractor);
            return this;
        }

        public Builder withStatsReporter(StatsReporter statsReporter) {
            this.metrics = new Metrics(new StatsFactoryImpl(statsReporter));
            return this;
        }

        public Builder withActiveSpanSource(ActiveSpanSource activeSpanSource) {
            this.activeSpanSource = activeSpanSource;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withZipkinSharedRpcSpan() {
            this.zipkinSharedRpcSpan = true;
            return this;
        }

        public Builder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder withTag(String key, boolean value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder withTag(String key, Number value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer build() {
            return new Tracer(this.serviceName, this.reporter, this.sampler, this.registry, this.clock, this.metrics, this.tags, this.zipkinSharedRpcSpan, this.activeSpanSource);
        }
    }

    class SpanBuilder
    implements Tracer.SpanBuilder {
        private String operationName = null;
        private long startTimeMicroseconds;
        private List<Reference> references = Collections.emptyList();
        private final Map<String, Object> tags = new HashMap<String, Object>();
        private boolean ignoreActiveSpan = false;

        SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        public Tracer.SpanBuilder asChildOf(BaseSpan<?> parent) {
            return this.addReference("child_of", parent.context());
        }

        public Tracer.SpanBuilder addReference(String referenceType, io.opentracing.SpanContext referencedContext) {
            if (!(referencedContext instanceof SpanContext)) {
                return this;
            }
            if (!"child_of".equals(referenceType) && !"follows_from".equals(referenceType)) {
                return this;
            }
            if (this.references.isEmpty()) {
                this.references = Collections.singletonList(new Reference((SpanContext)referencedContext, referenceType));
            } else {
                if (this.references.size() == 1) {
                    this.references = new ArrayList<Reference>(this.references);
                }
                this.references.add(new Reference((SpanContext)referencedContext, referenceType));
            }
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, boolean value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, Number value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
            this.startTimeMicroseconds = microseconds;
            return this;
        }

        private SpanContext createNewContext(String debugId) {
            long id = Utils.uniqueId();
            byte flags = 0;
            if (debugId != null) {
                flags = (byte)(flags | 3);
                this.tags.put("jaeger-debug-id", debugId);
                ((Tracer)Tracer.this).metrics.traceStartedSampled.inc(1L);
            } else {
                SamplingStatus samplingStatus = Tracer.this.sampler.sample(this.operationName, id);
                if (samplingStatus.isSampled()) {
                    flags = (byte)(flags | 1);
                    this.tags.putAll(samplingStatus.getTags());
                    ((Tracer)Tracer.this).metrics.traceStartedSampled.inc(1L);
                } else {
                    ((Tracer)Tracer.this).metrics.traceStartedNotSampled.inc(1L);
                }
            }
            return new SpanContext(id, id, 0L, flags);
        }

        private Map<String, String> createChildBaggage() {
            HashMap<String, String> baggage = null;
            if (this.references.size() == 1) {
                return this.references.get(0).getSpanContext().baggage();
            }
            for (Reference reference : this.references) {
                if (reference.getSpanContext().baggage() == null) continue;
                if (baggage == null) {
                    baggage = new HashMap<String, String>();
                }
                baggage.putAll(reference.getSpanContext().baggage());
            }
            return baggage;
        }

        private SpanContext createChildContext() {
            SpanContext preferredReference = this.preferredReference();
            if (this.isRpcServer()) {
                if (this.isSampled()) {
                    ((Tracer)Tracer.this).metrics.tracesJoinedSampled.inc(1L);
                } else {
                    ((Tracer)Tracer.this).metrics.tracesJoinedNotSampled.inc(1L);
                }
                if (Tracer.this.zipkinSharedRpcSpan) {
                    return preferredReference;
                }
            }
            return new SpanContext(preferredReference.getTraceId(), Utils.uniqueId(), preferredReference.getSpanId(), preferredReference.getFlags(), this.createChildBaggage(), null);
        }

        boolean isRpcServer() {
            return "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        }

        private SpanContext preferredReference() {
            Reference preferredReference = this.references.get(0);
            for (Reference reference : this.references) {
                if (!"child_of".equals(reference.getType()) || "child_of".equals(preferredReference.getType())) continue;
                preferredReference = reference;
                break;
            }
            return preferredReference.getSpanContext();
        }

        private boolean isSampled() {
            if (this.references != null) {
                for (Reference reference : this.references) {
                    if (!reference.getSpanContext().isSampled()) continue;
                    return true;
                }
            }
            return false;
        }

        private String debugId() {
            if (this.references.size() == 1 && this.references.get(0).getSpanContext().isDebugIdContainerOnly()) {
                return this.references.get(0).getSpanContext().getDebugId();
            }
            return null;
        }

        public io.opentracing.Span startManual() {
            if (this.references.isEmpty() && !this.ignoreActiveSpan && null != Tracer.this.activeSpanSource.activeSpan()) {
                this.asChildOf((BaseSpan<?>)Tracer.this.activeSpanSource.activeSpan());
            }
            String debugId = this.debugId();
            SpanContext context = this.references.isEmpty() ? this.createNewContext(null) : (debugId != null ? this.createNewContext(debugId) : this.createChildContext());
            long startTimeNanoTicks = 0L;
            boolean computeDurationViaNanoTicks = false;
            if (this.startTimeMicroseconds == 0L) {
                this.startTimeMicroseconds = Tracer.this.clock.currentTimeMicros();
                if (!Tracer.this.clock.isMicrosAccurate()) {
                    startTimeNanoTicks = Tracer.this.clock.currentNanoTicks();
                    computeDurationViaNanoTicks = true;
                }
            }
            Span span = new Span(Tracer.this, this.operationName, context, this.startTimeMicroseconds, startTimeNanoTicks, computeDurationViaNanoTicks, this.tags, this.references);
            if (context.isSampled()) {
                ((Tracer)Tracer.this).metrics.spansSampled.inc(1L);
            } else {
                ((Tracer)Tracer.this).metrics.spansNotSampled.inc(1L);
            }
            ((Tracer)Tracer.this).metrics.spansStarted.inc(1L);
            return span;
        }

        public ActiveSpan startActive() {
            return Tracer.this.activeSpanSource.makeActive(this.startManual());
        }

        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.ignoreActiveSpan = true;
            return this;
        }

        @Deprecated
        public io.opentracing.Span start() {
            return this.startManual();
        }
    }
}

