/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.security;

import com.sun.corba.se.spi.orb.ORB;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.wildfly.iiop.openjdk.security.SocketFactoryBase;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SSLSocketFactory
extends SocketFactoryBase {
    private static final String SSL_CONTEXT_CAPABILITY = "org.wildfly.security.ssl-context";
    private static final RuntimeCapability<Void> SSL_CONTEXT_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.security.ssl-context", (boolean)true, SSLContext.class).build();
    private static String serverSSLContextName = null;
    private static String clientSSLContextName = null;
    private SSLContext serverSSLContext = null;
    private SSLContext clientSSLContext = null;

    public static void setServerSSLContextName(String serverSSLContextName) {
        SSLSocketFactory.serverSSLContextName = serverSSLContextName;
    }

    public static void setClientSSLContextName(String clientSSLContextName) {
        SSLSocketFactory.clientSSLContextName = clientSSLContextName;
    }

    @Override
    public void setORB(ORB orb) {
        super.setORB(orb);
        ServiceContainer container = this.currentServiceContainer();
        ServiceName serverContextServiceName = SSL_CONTEXT_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{serverSSLContextName});
        this.serverSSLContext = (SSLContext)container.getRequiredService(serverContextServiceName).getValue();
        ServiceName clientContextServiceName = SSL_CONTEXT_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{clientSSLContextName});
        this.clientSSLContext = (SSLContext)container.getRequiredService(clientContextServiceName).getValue();
    }

    @Override
    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (type.equals("SSL")) {
            return this.createSSLServerSocket(inetSocketAddress.getPort(), 1000, InetAddress.getByName(inetSocketAddress.getHostName()));
        }
        return super.createServerSocket(type, inetSocketAddress);
    }

    @Override
    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (type.contains("SSL")) {
            return this.createSSLSocket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        return super.createSocket(type, inetSocketAddress);
    }

    public Socket createSSLSocket(String host, int port) throws IOException {
        InetAddress address = InetAddress.getByName(host);
        javax.net.ssl.SSLSocketFactory socketFactory = this.clientSSLContext.getSocketFactory();
        return socketFactory.createSocket(address, port);
    }

    public ServerSocket createSSLServerSocket(int port, int backlog, InetAddress inetAddress) throws IOException {
        SSLServerSocketFactory serverSocketFactory = this.serverSSLContext.getServerSocketFactory();
        return serverSocketFactory.createServerSocket(port, backlog, inetAddress);
    }

    private ServiceContainer currentServiceContainer() {
        if (WildFlySecurityManager.isChecking()) {
            return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
        }
        return CurrentServiceContainer.getServiceContainer();
    }
}

