/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.security.AccessController;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.wildfly.extension.messaging.activemq.ActiveMQServerService;
import org.wildfly.extension.messaging.activemq.JGroupsBroadcastEndpointFactory;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public class ActiveMQResourceAdapter
extends org.apache.activemq.artemis.ra.ActiveMQResourceAdapter {
    private static final long serialVersionUID = 170278234232275756L;

    protected BroadcastEndpointFactory createBroadcastEndpointFactory(ConnectionFactoryProperties overrideProperties) {
        String channelName;
        String string = channelName = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        if (channelName != null) {
            String channelRefName = this.getProperties().getJgroupsChannelRefName();
            String[] split = channelRefName.split("/");
            String serverName = split[0];
            String channelFactoryName = split[1];
            ActiveMQServerService service = (ActiveMQServerService)ActiveMQResourceAdapter.currentServiceContainer().getService(MessagingServices.getActiveMQServiceName(serverName)).getService();
            return new JGroupsBroadcastEndpointFactory(service.getChannelFactory(channelFactoryName), channelName);
        }
        return super.createBroadcastEndpointFactory(overrideProperties);
    }

    private static ServiceContainer currentServiceContainer() {
        return System.getSecurityManager() == null ? CurrentServiceContainer.getServiceContainer() : (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

