/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.enterprise.inject.Vetoed;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.SwarmInfo;
import org.wildfly.swarm.cli.CommandLineParser;
import org.wildfly.swarm.cli.Option;
import org.wildfly.swarm.cli.Options;
import org.wildfly.swarm.cli.YamlDumper;

@Vetoed
public class CommandLine {
    private static final String CONFIG_ELEMENT = "<config>";
    private static final String FRACTION = "fraction";
    private static final String ALL = "all";
    public static final Option<Boolean> HELP = new Option().withLong("help").withShort(Character.valueOf('h')).withDescription("Display this help").withDefault(() -> false).then((cmd, opt, value) -> cmd.put(opt, true));
    public static final Option<String> CONFIG_HELP = new Option().withLong("config-help").hasValue("<fraction>").withDescription("Display configuration help by fraction, or 'all' for all").then((cmd, opt, value) -> cmd.put(opt, value));
    public static final Option<String> YAML_HELP = new Option().withLong("yaml-help").hasValue("<fraction>").withDescription("Display example YAML configuration by fraction, or 'all' for all").then((cmd, opt, value) -> cmd.put(opt, value));
    public static final Option<Boolean> VERSION = new Option().withLong("version").withShort(Character.valueOf('v')).withDescription("Display the version of WildFly Swarm").withDefault(() -> false).then((cmd, opt, value) -> cmd.put(opt, true));
    public static final Option<Properties> PROPERTY = new Option().withShort(Character.valueOf('D')).hasValue("<name>[=<value>]").valueMayBeSeparate(false).withDescription("Set a system property").withDefault(Properties::new).then((cmd, opt, value) -> {
        String[] nameValue = value.split("=");
        Properties props = (Properties)cmd.get(opt);
        String propName = nameValue[0];
        String propValue = "true";
        if (nameValue.length > 1) {
            propValue = nameValue[1];
        }
        props.setProperty(propName, propValue);
    });
    public static final Option<URL> PROPERTIES_URL = new Option().withShort(Character.valueOf('P')).withLong("properties").hasValue("<url>").withDescription("Load system properties from the given URL").then((cmd, opt, value) -> cmd.put(opt, Option.toURL(value)));
    public static final Option<URL> SERVER_CONFIG = new Option().withShort(Character.valueOf('c')).withLong("server-config").hasValue("<config>").valueMayBeSeparate(true).withDescription("URL of the server configuration (e.g. standalone.xml)").withDefault(() -> CommandLine.resolveResource("standalone.xml")).then((cmd, opt, value) -> cmd.put(opt, Option.toURL(value)));
    public static final Option<List<URL>> CONFIG = new Option().withShort(Character.valueOf('s')).withLong("config").hasValue("<config>").valueMayBeSeparate(true).withDescription("URL to configuration YAML to use").then((cmd, opt, value) -> {
        ArrayList<URL> configs = (ArrayList<URL>)cmd.get(opt);
        if (configs == null) {
            configs = new ArrayList<URL>();
            cmd.put(opt, configs);
        }
        configs.add(Option.toURL(value));
    });
    public static final Option<List<String>> PROFILES = new Option().withShort(Character.valueOf('S')).withLong("profile").hasValue("<profile>").valueMayBeSeparate(true).withDescription("Selected profiles").then((cmd, opt, value) -> {
        ArrayList<String> profiles = (ArrayList<String>)cmd.get(opt);
        if (profiles == null) {
            profiles = new ArrayList<String>();
            cmd.put(opt, profiles);
        }
        profiles.add(value);
    });
    public static final Option<String> BIND = new Option().withShort(Character.valueOf('b')).hasValue("<value>").valueMayBeSeparate(true).withDescription("Set the property swarm.bind.address to <value>").then(CommandLine::put);
    private final Options options;
    private final Map<Option<?>, Object> values = new HashMap();
    private final List<String> extraArguments = new ArrayList<String>();
    private final List<String> invalidArguments = new ArrayList<String>();

    public static Options defaultOptions() {
        return new Options(HELP, CONFIG_HELP, YAML_HELP, VERSION, PROPERTY, PROPERTIES_URL, SERVER_CONFIG, CONFIG, PROFILES, BIND);
    }

    CommandLine(Options options) {
        this.options = options;
    }

    public <T> void put(Option<T> key, T value) {
        this.values.put(key, value);
    }

    public <T> T get(Option<T> key) {
        Object v = this.values.get(key);
        if (v == null) {
            v = key.defaultValue();
            this.values.put(key, v);
        }
        return (T)v;
    }

    public void displayHelp(PrintStream out) {
        this.options.displayHelp(out);
    }

    public void displayConfigHelp(PrintStream out, String fraction) throws IOException, ModuleLoadException {
        ModuleClassLoader cl = Module.getBootModuleLoader().loadModule("swarm.application").getClassLoader();
        Enumeration docs = cl.getResources("META-INF/configuration-meta.properties");
        Properties props = new Properties();
        while (docs.hasMoreElements()) {
            URL each = (URL)docs.nextElement();
            Properties fractionDocs = new Properties();
            fractionDocs.load(each.openStream());
            if (!fraction.equals(ALL) && !fraction.equals(fractionDocs.getProperty(FRACTION))) continue;
            fractionDocs.remove(FRACTION);
            props.putAll((Map<?, ?>)fractionDocs);
        }
        props.stringPropertyNames().stream().sorted().forEach(key -> {
            out.println("# " + key);
            out.println();
            out.println(this.formatDocs("    ", props.getProperty((String)key)));
            out.println();
        });
    }

    public void dumpYaml(PrintStream out, String fraction) throws IOException, ModuleLoadException {
        ModuleClassLoader cl = Module.getBootModuleLoader().loadModule("swarm.application").getClassLoader();
        Enumeration docs = cl.getResources("META-INF/configuration-meta.properties");
        Properties props = new Properties();
        while (docs.hasMoreElements()) {
            URL each = (URL)docs.nextElement();
            Properties fractionDocs = new Properties();
            fractionDocs.load(each.openStream());
            if (!fraction.equals(ALL) && !fraction.equals(fractionDocs.getProperty(FRACTION))) continue;
            fractionDocs.remove(FRACTION);
            props.putAll((Map<?, ?>)fractionDocs);
        }
        YamlDumper.dump(out, props);
    }

    private String formatDocs(String indent, String docs) {
        StringTokenizer tokens = new StringTokenizer(docs);
        StringBuilder formatted = new StringBuilder();
        int lineLength = indent.length();
        boolean freshLine = true;
        formatted.append(indent);
        while (tokens.hasMoreElements()) {
            String next = tokens.nextToken();
            if (lineLength + 1 + next.length() > 80) {
                formatted.append("\n");
                formatted.append(indent);
                lineLength = indent.length();
                freshLine = true;
            }
            if (freshLine) {
                freshLine = false;
            } else {
                formatted.append(" ");
            }
            lineLength += next.length();
            formatted.append(next);
        }
        return formatted.toString();
    }

    public void displayVersion(PrintStream out) {
        out.println("WildFly Swarm version " + SwarmInfo.VERSION);
    }

    public void applyProperties(Swarm swarm) throws IOException {
        URL propsUrl = this.get(PROPERTIES_URL);
        if (propsUrl != null) {
            Properties urlProps = new Properties();
            urlProps.load(propsUrl.openStream());
            for (String name : urlProps.stringPropertyNames()) {
                swarm.withProperty(name, urlProps.getProperty(name));
            }
        }
        Properties props = this.get(PROPERTY);
        for (String name : props.stringPropertyNames()) {
            swarm.withProperty(name, props.getProperty(name));
        }
        if (this.get(BIND) != null) {
            swarm.withProperty("swarm.bind.address", this.get(BIND));
        }
    }

    public void applyConfigurations(Swarm swarm) throws IOException {
        if (this.get(SERVER_CONFIG) != null) {
            swarm.withXmlConfig(this.get(SERVER_CONFIG));
        }
        if (this.get(CONFIG) != null) {
            List<URL> configs = this.get(CONFIG);
            for (URL config : configs) {
                swarm.withConfig(config);
            }
        }
        if (this.get(PROFILES) != null) {
            List<String> profiles = this.get(PROFILES);
            for (String profile : profiles) {
                swarm.withProfile(profile);
            }
        }
    }

    public void apply(Swarm swarm) throws IOException, ModuleLoadException {
        this.applyProperties(swarm);
        this.applyConfigurations(swarm);
        if (this.get(HELP).booleanValue()) {
            this.displayVersion(System.err);
            System.err.println();
            this.displayHelp(System.err);
            System.exit(0);
        }
        if (this.get(CONFIG_HELP) != null) {
            this.displayConfigHelp(System.err, this.get(CONFIG_HELP));
            System.exit(0);
        }
        if (this.get(YAML_HELP) != null) {
            this.dumpYaml(System.err, this.get(YAML_HELP));
            System.exit(0);
        }
        if (this.get(VERSION).booleanValue()) {
            this.displayVersion(System.err);
        }
    }

    void extraArgument(String arg) {
        this.extraArguments.add(arg);
    }

    public List<String> extraArguments() {
        return this.extraArguments;
    }

    public String[] extraArgumentsArray() {
        return this.extraArguments.toArray(new String[this.extraArguments.size()]);
    }

    void invalidArgument(String arg) {
        this.invalidArguments.add(arg);
    }

    public List<String> invalidArguments() {
        return this.invalidArguments;
    }

    public boolean hasInvalidArguments() {
        return !this.invalidArguments.isEmpty();
    }

    public static CommandLine parse(String ... args) throws Exception {
        return CommandLineParser.parse(CommandLine.defaultOptions(), args);
    }

    public static CommandLine parse(Options options, String ... args) throws Exception {
        return CommandLineParser.parse(options, args);
    }

    private static URL resolveResource(String path) {
        Path candidate = Paths.get(path, new String[0]);
        if (Files.exists(candidate, new LinkOption[0])) {
            try {
                return candidate.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL yml = null;
        try {
            Module appModule = Module.getBootModuleLoader().loadModule("swarm.application");
            yml = appModule.getClassLoader().getResource(path);
            if (yml != null) {
                return yml;
            }
        }
        catch (ModuleLoadException moduleLoadException) {
            // empty catch block
        }
        yml = ClassLoader.getSystemClassLoader().getResource(path);
        return yml;
    }
}

