/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal.wildfly;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class SelfContainedContainer {
    private static final String PRODUCT_SLOT = "main";
    private Bootstrap.ConfigurationPersisterFactory persisterFactory = null;
    private File tmpDir;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ServiceContainer serviceContainer;

    public SelfContainedContainer() {
        this.tmpDir = this.createTmpDir();
    }

    public SelfContainedContainer(Bootstrap.ConfigurationPersisterFactory configuration) {
        this();
        this.persisterFactory = configuration;
    }

    public ServiceContainer start(List<ModelNode> containerDefinition) throws ExecutionException, InterruptedException, ModuleLoadException {
        return this.start(containerDefinition, Collections.emptyList());
    }

    public ServiceContainer start(List<ModelNode> containerDefinition, Collection<ServiceActivator> additionalActivators) throws ExecutionException, InterruptedException, ModuleLoadException {
        long startTime = System.currentTimeMillis();
        if (LogManager.getLogManager().getClass().getName().equals("org.jboss.logmanager.LogManager")) {
            try {
                Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
                StdioContext.install();
                StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
                StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
            }
            catch (Throwable context) {
                // empty catch block
            }
        }
        Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule("org.jboss.vfs"));
        ServerEnvironment serverEnvironment = this.determineEnvironment(WildFlySecurityManager.getSystemPropertiesPrivileged(), WildFlySecurityManager.getSystemEnvironmentPrivileged(), ServerEnvironment.LaunchType.SELF_CONTAINED, startTime);
        Bootstrap bootstrap = Bootstrap.Factory.newInstance();
        final Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironment);
        configuration.setConfigurationPersisterFactory(new Bootstrap.ConfigurationPersisterFactory(){

            public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                ExtensibleConfigurationPersister delegate = SelfContainedContainer.this.persisterFactory.createConfigurationPersister(serverEnvironment, executorService);
                configuration.getExtensionRegistry().setWriterRegistry((SubsystemXmlWriterRegistry)delegate);
                return delegate;
            }
        });
        configuration.setModuleLoader(Module.getBootModuleLoader());
        ArrayList<ServiceActivator> activators = new ArrayList<ServiceActivator>();
        activators.addAll(additionalActivators);
        this.serviceContainer = (ServiceContainer)bootstrap.startup(configuration, activators).get();
        return this.serviceContainer;
    }

    public void stop() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.serviceContainer.addTerminateListener(info -> latch.countDown());
        this.serviceContainer.shutdown();
        latch.await();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                SelfContainedContainer.deleteRecursively(SelfContainedContainer.this.tmpDir);
            }
        });
        this.executor.shutdown();
    }

    public ServerEnvironment determineEnvironment(Properties systemProperties, Map<String, String> systemEnvironment, ServerEnvironment.LaunchType launchType, long startTime) {
        ProductConfig productConfig = ProductConfig.fromKnownSlot((String)PRODUCT_SLOT, (ModuleLoader)Module.getBootModuleLoader(), (Map)systemProperties);
        systemProperties.put("jboss.server.temp.dir", this.tmpDir.getAbsolutePath());
        ServerEnvironment serverEnvironment = new ServerEnvironment(null, systemProperties, systemEnvironment, null, null, launchType, RunningMode.NORMAL, productConfig, startTime, false);
        return serverEnvironment;
    }

    private File createTmpDir() {
        try {
            File tmpDir = File.createTempFile("wildfly-self-contained", ".d");
            if (tmpDir.exists()) {
                for (int i = 0; i < 10; ++i) {
                    if (!tmpDir.exists()) continue;
                    if (SelfContainedContainer.deleteRecursively(tmpDir)) break;
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (tmpDir.exists()) {
                    throw new RuntimeException("Unable to create directory");
                }
            }
            tmpDir.mkdirs();
            tmpDir.deleteOnExit();
            return tmpDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean deleteRecursively(File f) {
        if (!f.exists()) {
            return false;
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (SelfContainedContainer.deleteRecursively(children[i])) continue;
                return false;
            }
        }
        return f.delete();
    }
}

