/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaeger;

import java.util.Optional;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;

@DeploymentModule(name="org.wildfly.swarm.jaeger", slot="deployment")
@Configurable(value="swarm.jaeger")
public class JaegerFraction
implements Fraction<JaegerFraction> {
    @AttributeDocumentation(value="The service name. Required (via this parameter, system property or env var). Ex.: `order-manager`")
    private Defaultable<String> serviceName = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_SERVICE_NAME"));
    @AttributeDocumentation(value="The sampler type. Ex.: `const`")
    private Defaultable<String> samplerType = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_SAMPLER_TYPE"));
    @AttributeDocumentation(value="The sampler parameter (number). Ex.: `1`")
    private Defaultable<String> samplerParameter = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_SAMPLER_PARAM"));
    @AttributeDocumentation(value="The host name and port when using the remote controlled sampler")
    private Defaultable<String> samplerManagerHost = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_SAMPLER_MANAGER_HOST_PORT"));
    @AttributeDocumentation(value="Whether the reporter should also log the spans")
    private Defaultable<String> reporterLogSpans = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_REPORTER_LOG_SPANS"));
    @AttributeDocumentation(value="The hostname for communicating with agent via UDP")
    private Defaultable<String> agentHost = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_AGENT_HOST"));
    @AttributeDocumentation(value="The port for communicating with agent via UDP")
    private Defaultable<String> agentPort = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_AGENT_PORT"));
    @AttributeDocumentation(value="The reporter's flush interval (ms)")
    private Defaultable<String> reporterFlushInterval = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_REPORTER_FLUSH_INTERVAL"));
    @AttributeDocumentation(value="The reporter's maximum queue size")
    private Defaultable<String> reporterMaxQueueSize = Defaultable.string((String)JaegerFraction.getDefault("JAEGER_REPORTER_MAX_QUEUE_SIZE"));

    public String getServiceName() {
        return (String)this.serviceName.get();
    }

    public String getSamplerType() {
        return (String)this.samplerType.get();
    }

    public String getSamplerParameter() {
        return (String)this.samplerParameter.get();
    }

    public String getSamplerManagerHost() {
        return (String)this.samplerManagerHost.get();
    }

    public String getReporterLogSpans() {
        return (String)this.reporterLogSpans.get();
    }

    public String getAgentHost() {
        return (String)this.agentHost.get();
    }

    public String getAgentPort() {
        return (String)this.agentPort.get();
    }

    public String getReporterFlushInterval() {
        return (String)this.reporterFlushInterval.get();
    }

    public String getReporterMaxQueueSize() {
        return (String)this.reporterMaxQueueSize.get();
    }

    public String toString() {
        return "JaegerFraction{serviceName='" + (String)this.serviceName.get() + '\'' + ", samplerType='" + (String)this.samplerType.get() + '\'' + ", samplerParameter='" + (String)this.samplerParameter.get() + '\'' + ", samplerManagerHost='" + (String)this.samplerManagerHost.get() + '\'' + ", reporterLogSpans='" + (String)this.reporterLogSpans.get() + '\'' + ", agentHost='" + (String)this.agentHost.get() + '\'' + ", agentPort='" + (String)this.agentPort.get() + '\'' + ", reporterFlushInterval='" + (String)this.reporterFlushInterval.get() + '\'' + ", reporterMaxQueueSize='" + (String)this.reporterMaxQueueSize.get() + '\'' + '}';
    }

    private static String getDefault(String key) {
        return Optional.ofNullable(System.getProperty(key, System.getenv(key))).orElse("");
    }
}

