/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import org.jboss.as.server.CurrentServiceContainer;
import org.wildfly.extension.nosql.cdi.DefaultLiteral;
import org.wildfly.extension.nosql.cdi.NamedLiteral;
import org.wildfly.extension.nosql.subsystem.mongodb.MongoSubsystemService;
import org.wildfly.nosql.common.ConnectionServiceAccess;
import org.wildfly.nosql.common.SubsystemService;
import org.wildfly.nosql.common.spi.NoSQLConnection;

public class MongoExtension
implements Extension {
    private final Class mongoClientClass;
    private final Class mongoDatabaseClass;
    private static final Logger log = Logger.getLogger(MongoExtension.class.getName());

    public MongoExtension(Class mongoClientClass, Class mongoDatabaseClass) {
        this.mongoClientClass = mongoClientClass;
        this.mongoDatabaseClass = mongoDatabaseClass;
    }

    void registerNoSQLSourceBeans(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (bm.getBeans((Type)this.mongoClientClass, new Annotation[]{DefaultLiteral.INSTANCE}).isEmpty()) {
            for (String profile : this.getService().profileNames()) {
                log.log(Level.INFO, "Registering bean for profile {0}", profile);
                abd.addBean(bm.createBean(new MongoClientBeanAttributes(bm.createBeanAttributes(bm.createAnnotatedType(this.mongoClientClass)), profile), this.mongoClientClass, new MongoClientProducerFactory(profile, this.mongoClientClass)));
                abd.addBean(bm.createBean(new MongoDatabaseBeanAttributes(bm.createBeanAttributes(bm.createAnnotatedType(this.mongoDatabaseClass)), profile), this.mongoDatabaseClass, new MongoDatabaseProducerFactory(profile, this.mongoDatabaseClass)));
            }
        } else {
            log.log(Level.INFO, "Application contains a default MongoClient Bean, automatic registration will be disabled");
        }
    }

    private SubsystemService getService() {
        return (SubsystemService)CurrentServiceContainer.getServiceContainer().getService(MongoSubsystemService.serviceName()).getValue();
    }

    private static class MongoDatabaseProducerFactory<T>
    implements InjectionTargetFactory<T> {
        private final String profile;
        private final Class mongoDatabaseClass;

        MongoDatabaseProducerFactory(String profile, Class mongoDatabaseClass) {
            this.profile = profile;
            this.mongoDatabaseClass = mongoDatabaseClass;
        }

        public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
            return new InjectionTarget<T>(){

                public void inject(T instance, CreationalContext<T> ctx) {
                }

                public void postConstruct(T instance) {
                }

                public void preDestroy(T instance) {
                }

                public T produce(CreationalContext<T> ctx) {
                    NoSQLConnection noSQLConnection = ConnectionServiceAccess.connection((String)profile);
                    return noSQLConnection.unwrap(mongoDatabaseClass);
                }

                public void dispose(T database) {
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.EMPTY_SET;
                }
            };
        }
    }

    private static class MongoDatabaseBeanAttributes<T>
    implements BeanAttributes<T> {
        private BeanAttributes<T> delegate;
        private final String profile;

        MongoDatabaseBeanAttributes(BeanAttributes<T> beanAttributes, String profile) {
            this.delegate = beanAttributes;
            this.profile = profile;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>(this.delegate.getQualifiers());
            NamedLiteral namedLiteral = new NamedLiteral(this.profile);
            qualifiers.add((Annotation)((Object)namedLiteral));
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public Set<Type> getTypes() {
            return this.delegate.getTypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }
    }

    private static class MongoClientProducerFactory<T>
    implements InjectionTargetFactory<T> {
        final String profile;
        final Class mongoClientClass;

        MongoClientProducerFactory(String profile, Class mongoClientClass) {
            this.profile = profile;
            this.mongoClientClass = mongoClientClass;
        }

        public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
            return new InjectionTarget<T>(){

                public void inject(T instance, CreationalContext<T> ctx) {
                }

                public void postConstruct(T instance) {
                }

                public void preDestroy(T instance) {
                }

                public T produce(CreationalContext<T> ctx) {
                    NoSQLConnection noSQLConnection = ConnectionServiceAccess.connection((String)profile);
                    return noSQLConnection.unwrap(mongoClientClass);
                }

                public void dispose(T connection) {
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.EMPTY_SET;
                }
            };
        }
    }

    private static class MongoClientBeanAttributes<T>
    implements BeanAttributes<T> {
        private BeanAttributes<T> delegate;
        private final String profile;

        MongoClientBeanAttributes(BeanAttributes<T> beanAttributes, String profile) {
            this.delegate = beanAttributes;
            this.profile = profile;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>(this.delegate.getQualifiers());
            NamedLiteral namedLiteral = new NamedLiteral(this.profile);
            qualifiers.add((Annotation)((Object)namedLiteral));
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public Set<Type> getTypes() {
            return this.delegate.getTypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }
    }
}

