/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.CurrentServiceContainer;
import org.wildfly.extension.nosql.cdi.DefaultLiteral;
import org.wildfly.extension.nosql.cdi.OrientBeanAttributes;
import org.wildfly.extension.nosql.cdi.OrientProducerFactory;
import org.wildfly.extension.nosql.subsystem.orientdb.OrientSubsystemService;
import org.wildfly.nosql.common.SubsystemService;

public class OrientExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(OrientExtension.class.getName());
    private final Class oPartitionedDatabasePoolClass;

    public OrientExtension(Class oPartitionedDatabasePoolClass) {
        this.oPartitionedDatabasePoolClass = oPartitionedDatabasePoolClass;
    }

    public void registerNoSQLSourceBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (beanManager.getBeans((Type)this.oPartitionedDatabasePoolClass, new Annotation[]{DefaultLiteral.INSTANCE}).isEmpty()) {
            for (String profile : this.getService().profileNames()) {
                LOGGER.log(Level.INFO, "Registering " + this.oPartitionedDatabasePoolClass + " bean for profile {0}", profile);
                afterBeanDiscovery.addBean(this.getBean(beanManager, this.oPartitionedDatabasePoolClass, profile));
            }
        } else {
            LOGGER.log(Level.INFO, "Application contains a default " + this.oPartitionedDatabasePoolClass + " Bean, automatic registration will be disabled");
        }
    }

    private SubsystemService getService() {
        return (SubsystemService)CurrentServiceContainer.getServiceContainer().getService(OrientSubsystemService.SERVICE_NAME).getValue();
    }

    private <T> Bean<T> getBean(BeanManager beanManager, Class<T> beanClass, String profile) {
        BeanAttributes beanAttributes = beanManager.createBeanAttributes(beanManager.createAnnotatedType(beanClass));
        return beanManager.createBean(new OrientBeanAttributes(beanAttributes, profile), beanClass, new OrientProducerFactory<T>(beanClass, profile));
    }
}

