/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerEncoder;
import org.geolatte.geom.codec.db.sqlserver.CountingPositionSequenceBuilder;
import org.geolatte.geom.codec.db.sqlserver.Figure;
import org.geolatte.geom.codec.db.sqlserver.FigureAttribute;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.Shape;

class PolygonSqlServerEncoder
extends AbstractSqlServerEncoder {
    PolygonSqlServerEncoder() {
    }

    @Override
    public boolean accepts(Geometry geom) {
        return geom instanceof Polygon;
    }

    @Override
    protected void encode(Geometry<?> geom, int parentShapeIndex, CountingPositionSequenceBuilder<?> coordinates, List<Figure> figures, List<Shape> shapes) {
        if (!(geom instanceof Polygon)) {
            throw new IllegalArgumentException("Polygon geometry expected.");
        }
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentShapeIndex, -1, OpenGisType.POLYGON));
            return;
        }
        Polygon polygon = (Polygon)geom;
        int figureOffset = figures.size();
        shapes.add(new Shape(parentShapeIndex, figureOffset, OpenGisType.POLYGON));
        int pointOffset = coordinates.getNumAdded();
        this.addExteriorRing(polygon, coordinates, figures);
        this.addInteriorRings(polygon, coordinates, figures);
    }

    private void addInteriorRings(Polygon<?> geom, CountingPositionSequenceBuilder<?> coordinates, List<Figure> figures) {
        for (int idx = 0; idx < geom.getNumInteriorRing(); ++idx) {
            this.addInteriorRing(geom.getInteriorRingN(idx), coordinates, figures);
        }
    }

    private void addInteriorRing(LineString<?> ring, CountingPositionSequenceBuilder<?> coordinates, List<Figure> figures) {
        int pointOffset = coordinates.getNumAdded();
        this.addPoints(ring, coordinates);
        Figure figure = new Figure(FigureAttribute.InteriorRing, pointOffset);
        figures.add(figure);
    }

    private void addPoints(LineString<?> ring, CountingPositionSequenceBuilder<?> coordinates) {
        double[] c = new double[coordinates.getCoordinateDimension()];
        for (Position p : ring.getPositions()) {
            coordinates.add(p.toArray(c));
        }
    }

    private void addExteriorRing(Polygon geom, CountingPositionSequenceBuilder coordinates, List<Figure> figures) {
        LinearRing shell = geom.getExteriorRing();
        int offset = coordinates.getNumAdded();
        this.addPoints(shell, coordinates);
        Figure exterior = new Figure(FigureAttribute.ExteriorRing, offset);
        figures.add(exterior);
    }
}

