/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.infinispan.spi.persistence.DelimitedKeyFormat;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;
import org.wildfly.clustering.web.infinispan.SessionKeyExternalizer;

public class IndexedSessionKeyExternalizer<K extends Key<String>>
extends DelimitedKeyFormat<K>
implements Externalizer<K> {
    private static final Externalizer<String> EXTERNALIZER = SessionKeyExternalizer.EXTERNALIZER;
    private final BiFunction<String, Integer, K> resolver;
    private final ToIntFunction<K> index;

    protected IndexedSessionKeyExternalizer(Class<K> targetClass, ToIntFunction<K> index, BiFunction<String, Integer, K> resolver) {
        super(targetClass, "#", parts -> (Key)resolver.apply(parts[0], Integer.valueOf(parts[1])), key -> new String[]{(String)key.getValue(), Integer.toString(index.applyAsInt(key))});
        this.index = index;
        this.resolver = resolver;
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        EXTERNALIZER.writeObject(output, key.getValue());
        IndexExternalizer.VARIABLE.writeData((DataOutput)output, this.index.applyAsInt(key));
    }

    public K readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String id = (String)EXTERNALIZER.readObject(input);
        int index = IndexExternalizer.VARIABLE.readData((DataInput)input);
        return (K)((Key)this.resolver.apply(id, index));
    }
}

