/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.wildfly.extension.messaging.activemq.DefaultCredentials;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class ElytronSecurityManager
implements ActiveMQSecurityManager {
    private final SecurityDomain securityDomain;
    private final String defaultUser;
    private final String defaultPassword;

    public ElytronSecurityManager(SecurityDomain securityDomain) {
        if (securityDomain == null) {
            throw MessagingLogger.ROOT_LOGGER.invalidNullSecurityDomain();
        }
        this.securityDomain = securityDomain;
        this.defaultUser = DefaultCredentials.getUsername();
        this.defaultPassword = DefaultCredentials.getPassword();
    }

    public boolean validateUser(String username, String password) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        return this.authenticate(username, password) != null;
    }

    public boolean validateUserAndRole(String username, String password, Set<Role> roles, CheckType checkType) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        SecurityIdentity identity = this.authenticate(username, password);
        Set filteredRoles = roles.stream().filter(arg_0 -> ((CheckType)checkType).hasRole(arg_0)).map(Role::getName).collect(Collectors.toSet());
        return identity.getRoles().containsAny(filteredRoles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityIdentity authenticate(String username, String password) {
        ServerAuthenticationContext context = this.securityDomain.createNewAuthenticationContext();
        PasswordGuessEvidence evidence = null;
        try {
            if (password == null) {
                if (username == null) {
                    if (context.authorizeAnonymous()) {
                        context.succeed();
                        SecurityIdentity securityIdentity = context.getAuthorizedIdentity();
                        return securityIdentity;
                    }
                    context.fail();
                    SecurityIdentity securityIdentity = null;
                    return securityIdentity;
                }
                context.fail();
                SecurityIdentity securityIdentity = null;
                return securityIdentity;
            }
            context.setAuthenticationName(username);
            evidence = new PasswordGuessEvidence(password.toCharArray());
            if (context.verifyEvidence((Evidence)evidence)) {
                if (context.authorize()) {
                    context.succeed();
                    SecurityIdentity securityIdentity = context.getAuthorizedIdentity();
                    return securityIdentity;
                }
                context.fail();
                MessagingLogger.ROOT_LOGGER.failedAuthorization(username);
            } else {
                context.fail();
                MessagingLogger.ROOT_LOGGER.failedAuthentication(username);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
            context.fail();
            MessagingLogger.ROOT_LOGGER.failedAuthenticationWithException(e, username, e.getMessage());
        }
        finally {
            if (evidence != null) {
                evidence.destroy();
            }
        }
        return null;
    }
}

