/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection.closabledictionary;

import com.orientechnologies.common.collection.closabledictionary.OClosableEntry;
import com.orientechnologies.common.collection.closabledictionary.OClosableItem;
import java.util.Iterator;
import java.util.NoSuchElementException;

class OClosableLRUList<K, V extends OClosableItem>
implements Iterable<OClosableEntry<K, V>> {
    private int size;
    private OClosableEntry<K, V> head;
    private OClosableEntry<K, V> tail;

    OClosableLRUList() {
    }

    void remove(OClosableEntry<K, V> entry) {
        OClosableEntry<K, V> next = entry.getNext();
        OClosableEntry<K, V> prev = entry.getPrev();
        if (next == null && prev == null && entry != this.head) {
            return;
        }
        if (prev != null) assert (prev.getNext() == entry);
        if (next != null) assert (next.getPrev() == entry);
        if (next != null) {
            next.setPrev(prev);
        }
        if (prev != null) {
            prev.setNext(next);
        }
        if (this.head == entry) {
            assert (entry.getPrev() == null);
            this.head = next;
        }
        if (this.tail == entry) {
            assert (entry.getNext() == null);
            this.tail = prev;
        }
        entry.setNext(null);
        entry.setPrev(null);
        --this.size;
    }

    boolean contains(OClosableEntry<K, V> entry) {
        return entry.getNext() != null || entry.getPrev() != null || entry == this.head;
    }

    void moveToTheTail(OClosableEntry<K, V> entry) {
        boolean newEntry;
        if (this.tail == entry) {
            assert (entry.getNext() == null);
            return;
        }
        OClosableEntry<K, V> next = entry.getNext();
        OClosableEntry<K, V> prev = entry.getPrev();
        boolean bl = newEntry = next == null && prev == null && entry != this.head;
        if (prev != null) assert (prev.getNext() == entry);
        if (next != null) assert (next.getPrev() == entry);
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        if (this.head == entry) {
            assert (entry.getPrev() == null);
            this.head = next;
        }
        entry.setPrev(this.tail);
        entry.setNext(null);
        if (this.tail != null) {
            assert (this.tail.getNext() == null);
            this.tail.setNext(entry);
            this.tail = entry;
        } else {
            this.head = entry;
            this.tail = this.head;
        }
        if (newEntry) {
            ++this.size;
        }
    }

    int size() {
        return this.size;
    }

    OClosableEntry<K, V> poll() {
        if (this.head == null) {
            return null;
        }
        OClosableEntry entry = this.head;
        OClosableEntry next = this.head.getNext();
        assert (next == null || next.getPrev() == this.head);
        this.head = next;
        if (next != null) {
            next.setPrev(null);
        }
        assert (this.head == null || this.head.getPrev() == null);
        if (this.head == null) {
            this.tail = null;
        }
        entry.setNext(null);
        assert (entry.getPrev() == null);
        --this.size;
        return entry;
    }

    @Override
    public Iterator<OClosableEntry<K, V>> iterator() {
        return new Iterator<OClosableEntry<K, V>>(){
            private OClosableEntry<K, V> next;
            private OClosableEntry<K, V> current;
            {
                this.next = OClosableLRUList.this.head;
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public OClosableEntry<K, V> next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = this.next.getNext();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException("Method next was not called");
                }
                OClosableLRUList.this.remove(this.current);
                this.current = null;
            }
        };
    }

    boolean assertForwardStructure() {
        if (this.head == null) {
            return this.tail == null;
        }
        OClosableEntry<K, V> current = this.head;
        while (current.getNext() != null) {
            OClosableEntry<K, V> prev = current.getPrev();
            OClosableEntry<K, V> next = current.getNext();
            if (prev != null) assert (prev.getNext() == current);
            if (next != null) assert (next.getPrev() == current);
            current = current.getNext();
        }
        return current == this.tail;
    }

    boolean assertBackwardStructure() {
        if (this.tail == null) {
            return this.head == null;
        }
        OClosableEntry<K, V> current = this.tail;
        while (current.getPrev() != null) {
            OClosableEntry<K, V> prev = current.getPrev();
            OClosableEntry<K, V> next = current.getNext();
            if (prev != null) assert (prev.getNext() == current);
            if (next != null) assert (next.getPrev() == current);
            current = current.getPrev();
        }
        return current == this.head;
    }
}

