/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.BeginInvalidationCommand;
import org.hibernate.cache.infinispan.util.EndInvalidationCommand;
import org.hibernate.cache.infinispan.util.EvictAllCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;

public class CacheCommandInitializer
implements ModuleCommandInitializer {
    private final ConcurrentHashMap<String, PutFromLoadValidator> putFromLoadValidators = new ConcurrentHashMap();
    private CacheNotifier notifier;
    private Configuration configuration;
    private ClusteringDependentLogic clusteringDependentLogic;

    @Inject
    public void injectDependencies(CacheNotifier notifier, Configuration configuration, ClusteringDependentLogic clusteringDependentLogic) {
        this.notifier = notifier;
        this.configuration = configuration;
        this.clusteringDependentLogic = clusteringDependentLogic;
    }

    public void addPutFromLoadValidator(String cacheName, PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidators.put(cacheName, putFromLoadValidator);
    }

    public PutFromLoadValidator removePutFromLoadValidator(String cacheName) {
        return this.putFromLoadValidators.remove(cacheName);
    }

    public EvictAllCommand buildEvictAllCommand(String regionName) {
        return new EvictAllCommand(regionName);
    }

    public BeginInvalidationCommand buildBeginInvalidationCommand(Set<Flag> flags, Object[] keys, Object lockOwner) {
        return new BeginInvalidationCommand(this.notifier, flags, CommandInvocationId.generateId((Address)this.clusteringDependentLogic.getAddress()), keys, lockOwner);
    }

    public EndInvalidationCommand buildEndInvalidationCommand(String cacheName, Object[] keys, Object lockOwner) {
        return new EndInvalidationCommand(cacheName, keys, lockOwner);
    }

    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        switch (c.getCommandId()) {
            case 121: {
                EndInvalidationCommand endInvalidationCommand = (EndInvalidationCommand)c;
                endInvalidationCommand.setPutFromLoadValidator(this.putFromLoadValidators.get(endInvalidationCommand.getCacheName()));
                break;
            }
            case 122: {
                BeginInvalidationCommand beginInvalidationCommand = (BeginInvalidationCommand)c;
                beginInvalidationCommand.init(this.notifier, this.configuration);
            }
        }
    }
}

