/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.unpacker;

import org.msgpack.MessageTypeException;
import org.msgpack.unpacker.Accept;

final class LongAccept
extends Accept {
    long value;

    LongAccept() {
        super("integer");
    }

    @Override
    void acceptInteger(byte v) {
        this.value = v;
    }

    @Override
    void acceptInteger(short v) {
        this.value = v;
    }

    @Override
    void acceptInteger(int v) {
        this.value = v;
    }

    @Override
    void acceptInteger(long v) {
        this.value = v;
    }

    @Override
    void acceptUnsignedInteger(byte v) {
        this.value = v & 0xFF;
    }

    @Override
    void acceptUnsignedInteger(short v) {
        this.value = v & 0xFFFF;
    }

    @Override
    void acceptUnsignedInteger(int v) {
        this.value = v < 0 ? (long)(v & Integer.MAX_VALUE) + 0x80000000L : (long)v;
    }

    @Override
    void acceptUnsignedInteger(long v) {
        if (v < 0L) {
            throw new MessageTypeException();
        }
        this.value = v;
    }
}

