/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;

public interface OCluster {
    public void configure(OStorage var1, int var2, String var3, Object ... var4) throws IOException;

    public void configure(OStorage var1, OStorageClusterConfiguration var2) throws IOException;

    public void create(int var1) throws IOException;

    public void open() throws IOException;

    public void close() throws IOException;

    public void close(boolean var1) throws IOException;

    public void delete() throws IOException;

    public Object set(ATTRIBUTES var1, Object var2) throws IOException;

    public String encryption();

    public long getTombstonesCount();

    public void truncate() throws IOException;

    public OPhysicalPosition allocatePosition(byte var1) throws IOException;

    public OPhysicalPosition createRecord(byte[] var1, int var2, byte var3, OPhysicalPosition var4) throws IOException;

    public boolean deleteRecord(long var1) throws IOException;

    public void updateRecord(long var1, byte[] var3, int var4, byte var5) throws IOException;

    public void recycleRecord(long var1, byte[] var3, int var4, byte var5) throws IOException;

    public ORawBuffer readRecord(long var1) throws IOException;

    public ORawBuffer readRecordIfVersionIsNotLatest(long var1, int var3) throws IOException, ORecordNotFoundException;

    public boolean exists();

    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition var1) throws IOException;

    public long getEntries();

    public long getFirstPosition() throws IOException;

    public long getLastPosition() throws IOException;

    public long getNextPosition() throws IOException;

    public String getFileName();

    public int getId();

    public void synch() throws IOException;

    public String getName();

    public long getRecordsSize() throws IOException;

    public float recordGrowFactor();

    public float recordOverflowGrowFactor();

    public String compression();

    public boolean isHashBased();

    public boolean isSystemCluster();

    public OClusterEntryIterator absoluteIterator();

    public OPhysicalPosition[] higherPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] lowerPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] floorPositions(OPhysicalPosition var1) throws IOException;

    public boolean hideRecord(long var1) throws IOException;

    public ORecordConflictStrategy getRecordConflictStrategy();

    public void acquireAtomicExclusiveLock();

    public static enum ATTRIBUTES {
        NAME,
        USE_WAL,
        RECORD_GROW_FACTOR,
        RECORD_OVERFLOW_GROW_FACTOR,
        COMPRESSION,
        CONFLICTSTRATEGY,
        STATUS,
        ENCRYPTION;

    }
}

