/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.meta;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon31.ServletType;
import org.wildfly.swarm.spi.meta.FractionDetector;
import org.wildfly.swarm.spi.meta.PathSource;

public abstract class WebXmlFractionDetector
implements FractionDetector<PathSource> {
    private boolean detected = false;
    private boolean detectionComplete = false;
    private Collection<String> servletClasses = new HashSet<String>();
    protected WebAppDescriptor webXMl;

    @Override
    public String extensionToDetect() {
        return "xml";
    }

    @Override
    public boolean detectionComplete() {
        return this.detectionComplete;
    }

    @Override
    public boolean wasDetected() {
        return this.detected;
    }

    @Override
    public void detect(PathSource element) {
        if (!this.detectionComplete() && element != null) {
            try (InputStream input = element.getInputStream();){
                this.webXMl = (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).fromStream(input);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.webXMl != null && this.doDetect()) {
                this.detected = true;
                this.detectionComplete = true;
            }
        }
    }

    public void hasServlet(String servletClass) {
        this.servletClasses.add(servletClass);
    }

    protected boolean doDetect() {
        long servletsFound = this.webXMl.getAllServlet().stream().map(ServletType::getServletClass).filter(c -> this.servletClasses.contains(c)).count();
        return servletsFound > 0L;
    }
}

