/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.api.util;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.wildfly.swarm.microprofile.openapi.api.OpenApiConfig;
import org.wildfly.swarm.microprofile.openapi.api.models.servers.ServerImpl;

public class ServersUtil {
    private ServersUtil() {
    }

    public static final void configureServers(OpenApiConfig config, OpenAPI oai) {
        Set<String> servers = config.servers();
        if (servers != null && !servers.isEmpty()) {
            oai.servers(new ArrayList());
            for (String server : servers) {
                ServerImpl s = new ServerImpl();
                s.setUrl(server);
                oai.addServer((Server)s);
            }
        }
        Set pathNames = oai.getPaths().keySet();
        for (String pathName : pathNames) {
            PathItem pathItem = (PathItem)oai.getPaths().get((Object)pathName);
            ServersUtil.configureServers(config, pathName, pathItem);
        }
    }

    protected static void configureServers(OpenApiConfig config, String pathName, PathItem pathItem) {
        if (pathItem == null) {
            return;
        }
        Set<String> pathServers = config.pathServers(pathName);
        if (pathServers != null && !pathServers.isEmpty()) {
            pathItem.servers(new ArrayList());
            for (String pathServer : pathServers) {
                ServerImpl server = new ServerImpl();
                server.setUrl(pathServer);
                pathItem.addServer((Server)server);
            }
        }
        ServersUtil.configureServers(config, pathItem.getGET());
        ServersUtil.configureServers(config, pathItem.getPUT());
        ServersUtil.configureServers(config, pathItem.getPOST());
        ServersUtil.configureServers(config, pathItem.getDELETE());
        ServersUtil.configureServers(config, pathItem.getHEAD());
        ServersUtil.configureServers(config, pathItem.getOPTIONS());
        ServersUtil.configureServers(config, pathItem.getPATCH());
        ServersUtil.configureServers(config, pathItem.getTRACE());
    }

    protected static void configureServers(OpenApiConfig config, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.getOperationId() == null) {
            return;
        }
        Set<String> operationServers = config.operationServers(operation.getOperationId());
        if (operationServers != null && !operationServers.isEmpty()) {
            operation.servers(new ArrayList());
            for (String operationServer : operationServers) {
                ServerImpl server = new ServerImpl();
                server.setUrl(operationServer);
                operation.addServer((Server)server);
            }
        }
    }
}

