/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime.util;

import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.wildfly.swarm.microprofile.openapi.runtime.OpenApiConstants;
import org.wildfly.swarm.microprofile.openapi.runtime.util.ModelUtil;

public class JandexUtil {
    private JandexUtil() {
    }

    public static String refValue(AnnotationInstance annotation, RefType refType) {
        AnnotationValue value = annotation.value("ref");
        if (value == null) {
            return null;
        }
        String $ref = value.asString();
        if ($ref.startsWith("#/")) {
            return $ref;
        }
        switch (refType) {
            case Callback: {
                $ref = "#/components/callbacks/" + $ref;
                break;
            }
            case Example: {
                $ref = "#/components/examples/" + $ref;
                break;
            }
            case Header: {
                $ref = "#/components/headers/" + $ref;
                break;
            }
            case Link: {
                $ref = "#/components/links/" + $ref;
                break;
            }
            case Parameter: {
                $ref = "#/components/parameters/" + $ref;
                break;
            }
            case RequestBody: {
                $ref = "#/components/requestBodies/" + $ref;
                break;
            }
            case Response: {
                $ref = "#/components/responses/" + $ref;
                break;
            }
            case Schema: {
                $ref = "#/components/schemas/" + $ref;
                break;
            }
            case SecurityScheme: {
                $ref = "#/components/securitySchemes/" + $ref;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Jandex RefType " + (Object)((Object)refType));
            }
        }
        return $ref;
    }

    public static String stringValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public static Boolean booleanValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asBoolean();
    }

    public static Boolean booleanValueWithDefault(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        return value != null && value.asBoolean();
    }

    public static BigDecimal bigDecimalValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        if (value.kind() == AnnotationValue.Kind.DOUBLE) {
            return new BigDecimal(value.asDouble());
        }
        if (value.kind() == AnnotationValue.Kind.STRING) {
            return new BigDecimal(value.asString());
        }
        throw new RuntimeException("Call to bigDecimalValue failed because the annotation property was not a double or a String.");
    }

    public static Integer intValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asInt();
    }

    public static List<String> stringListValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(value.asStringArray()));
    }

    public static <T extends Enum> T enumValue(AnnotationInstance annotation, String propertyName, Class<T> clazz) {
        Enum[] constants;
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        String strVal = value.asString();
        for (Enum t : constants = (Enum[])clazz.getEnumConstants()) {
            if (!t.name().equals(strVal)) continue;
            return (T)t;
        }
        for (Enum t : constants) {
            if (!t.name().equalsIgnoreCase(strVal)) continue;
            return (T)t;
        }
        return null;
    }

    public static boolean isRef(AnnotationInstance annotation) {
        return annotation.value("ref") != null;
    }

    public static boolean isEmpty(AnnotationInstance annotation) {
        return Annotations.values().length == 0;
    }

    public static AnnotationInstance getClassAnnotation(ClassInfo ct, DotName name) {
        if (name == null) {
            return null;
        }
        Collection annotations = ct.classAnnotations();
        for (AnnotationInstance annotationInstance : annotations) {
            if (!annotationInstance.name().equals((Object)name)) continue;
            return annotationInstance;
        }
        return null;
    }

    public static Collection<ClassInfo> getJaxRsResourceClasses(IndexView index) {
        ArrayList<ClassInfo> resourceClasses = new ArrayList<ClassInfo>();
        Collection pathAnnotations = index.getAnnotations(OpenApiConstants.DOTNAME_PATH);
        for (AnnotationInstance pathAnno : pathAnnotations) {
            AnnotationTarget annotationTarget = pathAnno.target();
            if (annotationTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
            resourceClasses.add(annotationTarget.asClass());
        }
        return resourceClasses;
    }

    public static List<AnnotationInstance> getParameterAnnotations(MethodInfo method, final short paramPosition) {
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>(method.annotations());
        CollectionUtils.filter(annotations, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                AnnotationInstance annotation = (AnnotationInstance)object;
                AnnotationTarget target = annotation.target();
                return target != null && target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER && target.asMethodParameter().position() == paramPosition;
            }
        });
        return annotations;
    }

    public static String nameFromRef(AnnotationInstance annotation) {
        String ref = annotation.value("ref").asString();
        return ModelUtil.nameFromRef(ref);
    }

    public static List<AnnotationInstance> getRepeatableAnnotation(MethodInfo method, final DotName singleAnnotationName, DotName repeatableAnnotationName) {
        AnnotationInstance annotation;
        AnnotationValue annotationValue;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>(method.annotations());
        CollectionUtils.filter(annotations, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                AnnotationInstance annotation = (AnnotationInstance)object;
                return annotation.name().equals((Object)singleAnnotationName);
            }
        });
        if (repeatableAnnotationName != null && method.hasAnnotation(repeatableAnnotationName) && (annotationValue = (annotation = method.annotation(repeatableAnnotationName)).value()) != null) {
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            annotations.addAll(Arrays.asList(nestedArray));
        }
        return annotations;
    }

    public static List<AnnotationInstance> getRepeatableAnnotation(ClassInfo clazz, DotName singleAnnotationName, DotName repeatableAnnotationName) {
        AnnotationValue annotationValue;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
        AnnotationInstance single = JandexUtil.getClassAnnotation(clazz, singleAnnotationName);
        AnnotationInstance repeatable = JandexUtil.getClassAnnotation(clazz, repeatableAnnotationName);
        if (single != null) {
            annotations.add(single);
        }
        if (repeatable != null && (annotationValue = repeatable.value()) != null) {
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            annotations.addAll(Arrays.asList(nestedArray));
        }
        return annotations;
    }

    public static Type getMethodParameterType(MethodInfo method, short position) {
        Type type = (Type)method.parameters().get(position);
        return type;
    }

    public static Type getRequestBodyParameterClassType(MethodInfo method) {
        List methodParams = method.parameters();
        if (methodParams.isEmpty()) {
            return null;
        }
        for (short i = 0; i < methodParams.size(); i = (short)(i + 1)) {
            if (!JandexUtil.getParameterAnnotations(method, i).isEmpty()) continue;
            return ((Type)methodParams.get(i)).asClassType();
        }
        return null;
    }

    public static JaxRsParameterInfo getMethodParameterJaxRsInfo(MethodInfo method, int idx) {
        AnnotationInstance jaxRsAnno = JandexUtil.getMethodParameterAnnotation(method, idx, OpenApiConstants.DOTNAME_PATH_PARAM);
        if (jaxRsAnno != null) {
            JaxRsParameterInfo info = new JaxRsParameterInfo();
            info.in = Parameter.In.PATH;
            info.name = JandexUtil.stringValue(jaxRsAnno, "value");
            return info;
        }
        jaxRsAnno = JandexUtil.getMethodParameterAnnotation(method, idx, OpenApiConstants.DOTNAME_QUERY_PARAM);
        if (jaxRsAnno != null) {
            JaxRsParameterInfo info = new JaxRsParameterInfo();
            info.in = Parameter.In.QUERY;
            info.name = JandexUtil.stringValue(jaxRsAnno, "value");
            return info;
        }
        jaxRsAnno = JandexUtil.getMethodParameterAnnotation(method, idx, OpenApiConstants.DOTNAME_COOKIE_PARAM);
        if (jaxRsAnno != null) {
            JaxRsParameterInfo info = new JaxRsParameterInfo();
            info.in = Parameter.In.COOKIE;
            info.name = JandexUtil.stringValue(jaxRsAnno, "value");
            return info;
        }
        jaxRsAnno = JandexUtil.getMethodParameterAnnotation(method, idx, OpenApiConstants.DOTNAME_HEADER_PARAM);
        if (jaxRsAnno != null) {
            JaxRsParameterInfo info = new JaxRsParameterInfo();
            info.in = Parameter.In.HEADER;
            info.name = JandexUtil.stringValue(jaxRsAnno, "value");
            return info;
        }
        return null;
    }

    private static AnnotationInstance getMethodParameterAnnotation(MethodInfo method, int parameterIndex, DotName annotationName) {
        for (AnnotationInstance annotation : method.annotations()) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != parameterIndex || !annotation.name().equals((Object)annotationName)) continue;
            return annotation;
        }
        return null;
    }

    public static boolean isSimpleClassSchema(AnnotationInstance annotation) {
        List values = annotation.values();
        return values.size() == 1 && ((AnnotationValue)values.get(0)).name().equals("implementation");
    }

    public static boolean isSimpleArraySchema(AnnotationInstance annotation) {
        List values = annotation.values();
        if (values.size() != 2) {
            return false;
        }
        Schema.SchemaType type = JandexUtil.enumValue(annotation, "type", Schema.SchemaType.class);
        String implementation = JandexUtil.stringValue(annotation, "implementation");
        return type == Schema.SchemaType.ARRAY && implementation != null;
    }

    public static class JaxRsParameterInfo {
        public String name;
        public Parameter.In in;
    }

    public static enum RefType {
        Header,
        Schema,
        SecurityScheme,
        Callback,
        Link,
        Response,
        Parameter,
        Example,
        RequestBody;

    }
}

