/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithListValue;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.PermittedCandidates;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DeploymentOverlayHandler
extends BatchModeCommandHandler {
    private static final String ADD = "add";
    private static final String LINK = "link";
    private static final String LIST_CONTENT = "list-content";
    private static final String LIST_LINKS = "list-links";
    private static final String REDEPLOY_AFFECTED = "redeploy-affected";
    private static final String REMOVE = "remove";
    private static final String UPLOAD = "upload";
    private static final String WARN_MSG = "WARNING: redeployment is required on deployment ";
    private final ArgumentWithoutValue l = new ArgumentWithoutValue(this, "-l"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
            if (actionStr == null || DeploymentOverlayHandler.LIST_CONTENT.equals(actionStr) || DeploymentOverlayHandler.LIST_LINKS.equals(actionStr)) {
                return super.canAppearNext(ctx);
            }
            return false;
        }
    };
    private final ArgumentWithValue action;
    private final ArgumentWithValue name;
    private final ArgumentWithListValue content;
    private final ArgumentWithListValue serverGroups;
    private final ArgumentWithoutValue allServerGroups;
    private final ArgumentWithoutValue allRelevantServerGroups;
    private final ArgumentWithListValue deployments;
    private final ArgumentWithoutValue redeployAffected;
    private final FilenameTabCompleter pathCompleter;
    private AccessRequirement generalListPermission;
    private AccessRequirement addPermission;
    private AccessRequirement linkPermission;
    private AccessRequirement removePermission;
    private AccessRequirement redeployPermission;
    private AccessRequirement listContentPermission;
    private AccessRequirement listLinksPermission;

    public DeploymentOverlayHandler(CommandContext ctx) {
        super(ctx, "deployment-overlay", true);
        this.l.setAccessRequirement(this.generalListPermission);
        this.action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(PermittedCandidates.create(ADD, this.addPermission).add(LINK, this.linkPermission).add(LIST_CONTENT, this.listContentPermission).add(LIST_LINKS, this.listLinksPermission).add(REDEPLOY_AFFECTED, this.redeployPermission).add(REMOVE, this.removePermission).add(UPLOAD, this.addPermission)), 0, "--action");
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelNode response;
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                ModelNode op = new ModelNode();
                op.get("operation").set("read-children-names");
                op.get("address").setEmptyList();
                op.get("child-type").set("deployment-overlay");
                try {
                    response = client.execute(op);
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return Collections.emptyList();
                }
                ArrayList<String> names = new ArrayList<String>();
                for (ModelNode node : result.asList()) {
                    names.add(node.asString());
                }
                return names;
            }
        }), "--name");
        this.name.addRequiredPreceding(this.action);
        this.name.setAccessRequirement(AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.addPermission).requirement(this.removePermission).requirement(this.linkPermission).requirement(this.listContentPermission).requirement(this.listLinksPermission).requirement(this.redeployPermission).build());
        this.pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.content = new ArgumentWithListValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.UPLOAD.equals(actionStr)) {
                    int i = buffer.lastIndexOf(44);
                    if ((i = buffer.indexOf(61, i + 1)) < 0) {
                        return -1;
                    }
                    String path = buffer.substring(i + 1);
                    int pathResult = DeploymentOverlayHandler.this.pathCompleter.complete(ctx, path, path.length(), candidates);
                    if (pathResult < 0) {
                        return -1;
                    }
                    return i + 1 + pathResult;
                }
                if (DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    List<String> existing;
                    String nameStr = DeploymentOverlayHandler.this.name.getValue(ctx.getParsedCommandLine());
                    if (nameStr == null) {
                        return -1;
                    }
                    try {
                        existing = DeploymentOverlayHandler.this.loadContentFor(ctx.getModelControllerClient(), nameStr);
                    }
                    catch (CommandLineException e) {
                        return -1;
                    }
                    if (existing.isEmpty()) {
                        return buffer.length();
                    }
                    candidates.addAll(existing);
                    if (buffer.isEmpty()) {
                        return 0;
                    }
                    String[] specified = buffer.split(",+");
                    candidates.removeAll(Arrays.asList(specified));
                    if (buffer.charAt(buffer.length() - 1) == ',') {
                        return buffer.length();
                    }
                    String chunk = specified[specified.length - 1];
                    for (int i = 0; i < candidates.size(); ++i) {
                        if (candidates.get(i).startsWith(chunk)) continue;
                        candidates.remove(i);
                    }
                    return buffer.length() - chunk.length();
                }
                return -1;
            }
        }, "--content"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.UPLOAD.equals(actionStr) || DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }

            @Override
            protected ParsingState initParsingState() {
                ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
                if (Util.isWindows()) {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
                } else {
                    state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
                }
                return state;
            }
        };
        this.content.addRequiredPreceding(this.name);
        this.content.addCantAppearAfter(this.l);
        this.serverGroups = new ArgumentWithListValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                return Util.getServerGroups(ctx.getModelControllerClient());
            }
        }, "--server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.LINK.equals(actionStr) || DeploymentOverlayHandler.REMOVE.equals(actionStr) || DeploymentOverlayHandler.LIST_LINKS.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.serverGroups.addRequiredPreceding(this.name);
        this.allRelevantServerGroups = new ArgumentWithoutValue(this, "--all-relevant-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.allRelevantServerGroups.addRequiredPreceding(this.name);
        this.allRelevantServerGroups.addCantAppearAfter(this.serverGroups);
        this.serverGroups.addCantAppearAfter(this.allRelevantServerGroups);
        this.allServerGroups = new ArgumentWithoutValue(this, "--all-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.LINK.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.allServerGroups.addRequiredPreceding(this.name);
        this.allServerGroups.addCantAppearAfter(this.serverGroups);
        this.serverGroups.addCantAppearAfter(this.allServerGroups);
        this.deployments = new ArgumentWithListValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                String actionValue = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                ModelControllerClient client = ctx.getModelControllerClient();
                if (DeploymentOverlayHandler.REMOVE.equals(actionValue)) {
                    block9: {
                        String overlay = DeploymentOverlayHandler.this.name.getValue(ctx.getParsedCommandLine());
                        if (overlay == null) {
                            return Collections.emptyList();
                        }
                        try {
                            if (ctx.isDomainMode()) {
                                String groupsStr = DeploymentOverlayHandler.this.serverGroups.getValue(ctx.getParsedCommandLine());
                                if (groupsStr != null) {
                                    String[] groups = groupsStr.split(",+");
                                    if (groups.length == 1) {
                                        return DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, groups[0]));
                                    }
                                    if (groups.length > 1) {
                                        HashSet<String> commonLinks = new HashSet<String>();
                                        commonLinks.addAll(DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, groups[0])));
                                        for (int i = 1; i < groups.length; ++i) {
                                            commonLinks.retainAll(DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, groups[i])));
                                        }
                                        return commonLinks;
                                    }
                                }
                                break block9;
                            }
                            return DeploymentOverlayHandler.this.filterLinks(DeploymentOverlayHandler.this.loadLinkResources(client, overlay, null));
                        }
                        catch (CommandLineException commandLineException) {
                            // empty catch block
                        }
                    }
                    return Collections.emptyList();
                }
                return Util.getDeploymentRuntimeNames(client);
            }
        }, "--deployments"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode()) {
                    if (DeploymentOverlayHandler.this.serverGroups.isPresent(ctx.getParsedCommandLine()) || DeploymentOverlayHandler.this.allServerGroups.isPresent(ctx.getParsedCommandLine())) {
                        return super.canAppearNext(ctx);
                    }
                    return false;
                }
                String actionStr = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionStr == null) {
                    return false;
                }
                if (DeploymentOverlayHandler.ADD.equals(actionStr) || DeploymentOverlayHandler.LINK.equals(actionStr) || DeploymentOverlayHandler.REMOVE.equals(actionStr)) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.deployments.addRequiredPreceding(this.name);
        this.deployments.addCantAppearAfter(this.l);
        this.redeployAffected = new ArgumentWithoutValue(this, "--redeploy-affected"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (DeploymentOverlayHandler.this.deployments.isPresent(ctx.getParsedCommandLine())) {
                    return super.canAppearNext(ctx);
                }
                String actionValue = DeploymentOverlayHandler.this.action.getValue(ctx.getParsedCommandLine());
                if (actionValue != null && (actionValue.equals(DeploymentOverlayHandler.UPLOAD) || actionValue.equals(DeploymentOverlayHandler.REMOVE))) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.redeployAffected.addRequiredPreceding(this.name);
        this.redeployAffected.setAccessRequirement(this.redeployPermission);
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.generalListPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", "read-children-names").build();
        this.addPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", ADD).operation("deployment-overlay=?/content=?", ADD).build();
        this.linkPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?/deployment=?", ADD).serverGroupOperation("deployment-overlay=?", ADD).serverGroupOperation("deployment-overlay=?/deployment=?", ADD).build();
        this.removePermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", REMOVE).operation("deployment-overlay=?/content=?", REMOVE).operation("deployment-overlay=?/deployment=?", REMOVE).all().serverGroupOperation("deployment-overlay=?/deployment=?", REMOVE).serverGroupOperation("deployment-overlay=?", REMOVE).parent().build();
        this.redeployPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", "redeploy-links").serverGroupOperation("deployment-overlay=?", "redeploy-linksa").build();
        this.listContentPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", "read-children-names").build();
        this.listLinksPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment-overlay=?", "read-children-names").serverGroupOperation("deployment-overlay=?", "read-children-names").build();
        return AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.generalListPermission).requirement(this.addPermission).requirement(this.linkPermission).requirement(this.removePermission).requirement(this.redeployPermission).requirement(this.listContentPermission).requirement(this.listLinksPermission).build();
    }

    @Override
    public boolean isBatchMode(CommandContext ctx) {
        String action = this.action.getValue(ctx.getParsedCommandLine());
        if (action != null && (LIST_LINKS.equals(action) || LIST_CONTENT.equals(action))) {
            return false;
        }
        return super.isBatchMode(ctx);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (!args.hasProperties() || this.l.isPresent(args) && args.getOtherProperties().isEmpty() && args.getPropertyNames().size() == 1) {
            ModelNode response;
            ModelNode op = new ModelNode();
            op.get("address").setEmptyList();
            op.get("operation").set("read-children-names");
            op.get("child-type").set("deployment-overlay");
            try {
                response = ctx.getModelControllerClient().execute(op);
            }
            catch (IOException e) {
                throw new CommandLineException("Failed to execute read-children-names", e);
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                String descr = Util.getFailureDescription(response);
                if (descr != null) {
                    throw new CommandLineException(descr);
                }
                throw new CommandLineException("The response of read-children-names is missing result: " + response);
            }
            if (this.l.isPresent(args)) {
                for (ModelNode node : result.asList()) {
                    ctx.printLine(node.asString());
                }
            } else {
                ArrayList<String> names = new ArrayList<String>();
                for (ModelNode node : result.asList()) {
                    names.add(node.asString());
                }
                ctx.printColumns(names);
            }
            return;
        }
        String action = this.action.getValue(args, true);
        if (ADD.equals(action)) {
            this.add(ctx, true);
        } else if (UPLOAD.equals(action)) {
            this.upload(ctx, true);
        } else if (LIST_CONTENT.equals(action)) {
            this.listContent(ctx);
        } else if (LIST_LINKS.equals(action)) {
            this.listLinks(ctx);
        } else {
            super.doHandle(ctx);
        }
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String action = this.action.getValue(args, true);
        try {
            if (REMOVE.equals(action)) {
                return this.remove(ctx);
            }
            if (LINK.equals(action)) {
                return this.link(ctx);
            }
            if (REDEPLOY_AFFECTED.equals(action)) {
                return this.redeployAffected(ctx);
            }
            if (ADD.equals(action)) {
                return this.add(ctx, false);
            }
            if (UPLOAD.equals(action)) {
                return this.upload(ctx, false);
            }
            throw new CommandFormatException("Doesn't know how to build request for action '" + action + "'");
        }
        catch (CommandFormatException e) {
            throw e;
        }
        catch (CommandLineException e) {
            throw new CommandFormatException("Failed to build " + action + " request.", e);
        }
    }

    protected ModelNode redeployAffected(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.serverGroups, args);
        this.assertNotPresent(this.allServerGroups, args);
        this.assertNotPresent(this.allRelevantServerGroups, args);
        this.assertNotPresent(this.content, args);
        this.assertNotPresent(this.deployments, args);
        this.assertNotPresent(this.redeployAffected, args);
        String overlay = this.getName(ctx, false);
        ModelControllerClient client = ctx.getModelControllerClient();
        ModelNode redeployOp = new ModelNode();
        redeployOp.get("operation").set("composite");
        redeployOp.get("address").setEmptyList();
        ModelNode steps = redeployOp.get("steps");
        this.addRedeployStep(overlay, steps);
        if (!steps.isDefined() || steps.asList().isEmpty()) {
            throw new CommandFormatException("None of the deployments affected.");
        }
        return redeployOp;
    }

    private String getName(CommandContext ctx, boolean failInBatch) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String name = this.name.getValue(args, true);
        if (name == null) {
            throw new CommandFormatException(this.name + " is missing value.");
        }
        if (!(ctx.isBatchMode() && !failInBatch || Util.isValidPath(ctx.getModelControllerClient(), "deployment-overlay", name))) {
            throw new CommandFormatException("Deployment overlay " + name + " does not exist.");
        }
        return name;
    }

    protected void listLinks(CommandContext ctx) throws CommandLineException {
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allRelevantServerGroups, args);
        this.assertNotPresent(this.content, args);
        this.assertNotPresent(this.deployments, args);
        this.assertNotPresent(this.redeployAffected, args);
        String name = this.getName(ctx, true);
        String sg = this.serverGroups.getValue(ctx.getParsedCommandLine());
        if (ctx.isDomainMode()) {
            List<String> groups = sg == null ? Util.getServerGroups(client) : Arrays.asList(sg.split(",+"));
            if (groups.size() == 0) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " is missing value.");
            }
            for (String group : groups) {
                List<String> links = this.loadLinks(client, name, group);
                if (links.isEmpty()) continue;
                ctx.printLine("SERVER GROUP: " + group + Util.LINE_SEPARATOR);
                ctx.printColumns(links);
                ctx.printLine("");
            }
        } else {
            List<String> content = this.loadLinks(client, name, sg);
            if (this.l.isPresent(args)) {
                for (String contentPath : content) {
                    ctx.printLine(contentPath);
                }
            } else {
                ctx.printColumns(content);
            }
        }
    }

    protected void listContent(CommandContext ctx) throws CommandLineException {
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.serverGroups, args);
        this.assertNotPresent(this.allServerGroups, args);
        this.assertNotPresent(this.allRelevantServerGroups, args);
        this.assertNotPresent(this.deployments, args);
        this.assertNotPresent(this.content, args);
        this.assertNotPresent(this.redeployAffected, args);
        String name = this.getName(ctx, true);
        List<String> content = this.loadContentFor(client, name);
        if (this.l.isPresent(args)) {
            for (String contentPath : content) {
                ctx.printLine(contentPath);
            }
        } else {
            ctx.printColumns(content);
        }
    }

    protected ModelNode remove(CommandContext ctx) throws CommandLineException {
        List<String> sg;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allServerGroups, args);
        String name = this.getName(ctx, false);
        String contentStr = this.content.getValue(args);
        String deploymentStr = this.deployments.getValue(args);
        String sgStr = this.serverGroups.getValue(args);
        if (sgStr == null) {
            sg = this.allRelevantServerGroups.isPresent(args) ? Util.getServerGroupsReferencingOverlay(name, client) : null;
        } else {
            sg = Arrays.asList(sgStr.split(",+"));
            if (sg.isEmpty()) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " is missing value.");
            }
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        boolean redeploy = this.redeployAffected.isPresent(args);
        if (!this.redeployAffected.isPresent(args)) {
            this.printWarning(ctx, client, name, contentStr, deploymentStr);
        }
        if (contentStr == null && deploymentStr == null) {
            if (ctx.isDomainMode()) {
                List<String> groups = sg == null ? Util.getServerGroupsReferencingOverlay(name, client) : sg;
                for (String group : groups) {
                    if (redeploy) {
                        List<String> links = this.loadLinks(client, name, group);
                        for (String link : links) {
                            this.addRemoveDeploymentStep(name, group, redeploy, link, steps);
                        }
                    }
                    this.addRemoveOverlayStep(name, group, steps);
                }
                if (sg == null) {
                    this.addRemoveOverlayStep(name, null, steps);
                }
            } else {
                if (redeploy) {
                    List<String> links = this.loadLinks(client, name, null);
                    for (String link : links) {
                        this.addRemoveDeploymentStep(name, null, redeploy, link, steps);
                    }
                }
                this.addRemoveOverlayStep(name, null, steps);
            }
            return composite;
        }
        boolean redeployAll = false;
        if (contentStr != null) {
            redeployAll = redeploy;
            List<String> contentList = Arrays.asList(contentStr.split(",+"));
            for (String content : contentList) {
                ModelNode op = new ModelNode();
                ModelNode addr = op.get("address");
                addr.add("deployment-overlay", name);
                addr.add("content", content);
                op.get("operation").set(REMOVE);
                steps.add(op);
            }
        }
        if (deploymentStr != null) {
            List<String> links = Arrays.asList(deploymentStr.split(",+"));
            if (ctx.isDomainMode()) {
                if (sg == null) {
                    throw new CommandFormatException(this.serverGroups.getFullName() + " or " + this.allRelevantServerGroups.getFullName() + " is required.");
                }
                for (String group : sg) {
                    for (String link : links) {
                        this.addRemoveDeploymentStep(name, group, redeploy, link, steps);
                    }
                }
            } else {
                for (String link : links) {
                    this.addRemoveDeploymentStep(name, null, redeploy, link, steps);
                }
            }
        }
        if (redeployAll) {
            this.addRedeployStep(name, steps);
        }
        return composite;
    }

    private void addRedeployStep(String overlay, ModelNode steps) {
        this.addRedeployStep(overlay, (List<String>)null, null, steps);
    }

    private void addRedeployStep(String overlay, String linkName, String sgName, ModelNode steps) {
        this.addRedeployStep(overlay, Arrays.asList(linkName), sgName, steps);
    }

    private void addRedeployStep(String overlay, List<String> linkNames, String sgName, ModelNode steps) {
        ModelNode redeployOp = new ModelNode();
        ModelNode addr = redeployOp.get("address");
        if (sgName != null) {
            addr.add("server-group", sgName);
        }
        addr.add("deployment-overlay", overlay);
        redeployOp.get("operation").set("redeploy-links");
        if (linkNames != null) {
            ModelNode lst = new ModelNode();
            for (String str : linkNames) {
                lst.add(str);
            }
            redeployOp.get("deployments").set(lst);
        }
        steps.add(redeployOp);
    }

    private void addRemoveOverlayStep(String name, String group, ModelNode steps) {
        ModelNode op = new ModelNode();
        ModelNode addr = op.get("address");
        if (group != null) {
            addr.add("server-group", group);
        }
        addr.add("deployment-overlay", name);
        op.get("operation").set(REMOVE);
        steps.add(op);
    }

    private void addRemoveDeploymentStep(String name, String group, boolean redeploy, String deployment, ModelNode steps) {
        ModelNode op = new ModelNode();
        ModelNode addr = op.get("address");
        if (group != null) {
            addr.add("server-group", group);
        }
        addr.add("deployment-overlay", name);
        addr.add("deployment", deployment);
        op.get("operation").set(REMOVE);
        if (redeploy) {
            op.get(REDEPLOY_AFFECTED).set(true);
        }
        steps.add(op);
    }

    private void printWarning(CommandContext ctx, ModelControllerClient client, String name, String content, String deployment) throws CommandLineException {
        if (ctx.isDomainMode()) {
            for (String sgName : Util.getServerGroups(client)) {
                this.printWarningMessage(ctx, client, name, content, deployment, sgName);
            }
        } else {
            this.printWarningMessage(ctx, client, name, content, deployment, null);
        }
    }

    private void printWarningMessage(CommandContext ctx, ModelControllerClient client, String name, String content, String deployment, String sgName) throws CommandLineException {
        if (content == null && deployment != null) {
            this.printLine(ctx, Arrays.asList(deployment.split(",+")), sgName);
        } else {
            ModelNode linkResources = this.loadLinkResources(client, name, sgName);
            if (linkResources != null && !linkResources.keys().isEmpty()) {
                this.printLine(ctx, linkResources.keys(), sgName);
            }
        }
    }

    private void printLine(CommandContext ctx, Collection<String> deployment, String sgName) {
        String message = WARN_MSG + deployment;
        if (sgName == null) {
            ctx.printLine(message);
        } else {
            ctx.printLine(message + " in server group " + sgName);
        }
    }

    protected ModelNode add(CommandContext ctx, boolean stream) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allRelevantServerGroups, args);
        String name = this.name.getValue(args, true);
        String contentStr = this.content.getValue(args, true);
        String[] contentPairs = contentStr.split(",+");
        if (contentPairs.length == 0) {
            throw new CommandFormatException("Overlay content is not specified.");
        }
        String[] contentNames = new String[contentPairs.length];
        File[] contentPaths = new File[contentPairs.length];
        for (int i = 0; i < contentPairs.length; ++i) {
            String pair = contentPairs[i];
            int equalsIndex = pair.indexOf(61);
            if (equalsIndex < 0) {
                throw new CommandFormatException("Content pair is not following archive-path=fs-path format: '" + pair + "'");
            }
            contentNames[i] = pair.substring(0, equalsIndex);
            if (contentNames[i].length() == 0) {
                throw new CommandFormatException("The archive path is missing for the content '" + pair + "'");
            }
            String path = pair.substring(equalsIndex + 1);
            if (path.length() == 0) {
                throw new CommandFormatException("The filesystem paths is missing for the content '" + pair + "'");
            }
            File f = new File(path = this.pathCompleter.translatePath(path));
            if (!f.exists()) {
                throw new CommandFormatException("Content file doesn't exist " + f.getAbsolutePath());
            }
            contentPaths[i] = f;
        }
        String[] deployments = this.getLinks(this.deployments, args);
        ModelControllerClient client = ctx.getModelControllerClient();
        ModelNode composite = new ModelNode();
        OperationBuilder opBuilder = stream ? new OperationBuilder(composite, true) : null;
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelNode op = new ModelNode();
        ModelNode address = op.get("address");
        address.add("deployment-overlay", name);
        op.get("operation").set(ADD);
        steps.add(op);
        for (int i = 0; i < contentNames.length; ++i) {
            String contentName = contentNames[i];
            op = new ModelNode();
            address = op.get("address");
            address.add("deployment-overlay", name);
            address.add("content", contentName);
            op.get("operation").set(ADD);
            if (opBuilder != null) {
                op.get("content").get("input-stream-index").set(i);
                opBuilder.addFileAsAttachment(contentPaths[i]);
            } else {
                op.get("content").get("bytes").set(Util.readBytes(contentPaths[i]));
            }
            steps.add(op);
        }
        if (deployments != null) {
            if (ctx.isDomainMode()) {
                List<String> sg = this.getServerGroupsToLink(ctx);
                for (String group : sg) {
                    op = new ModelNode();
                    address = op.get("address");
                    address.add("server-group", group);
                    address.add("deployment-overlay", name);
                    op.get("operation").set(ADD);
                    steps.add(op);
                    this.addAddRedeployLinksSteps(ctx, steps, name, group, deployments, false);
                }
            } else {
                this.addAddRedeployLinksSteps(ctx, steps, name, null, deployments, false);
            }
        } else if (ctx.isDomainMode() && (this.serverGroups.isPresent(args) || this.allServerGroups.isPresent(args))) {
            throw new CommandFormatException("server groups are specified but " + this.deployments.getFullName() + " is not.");
        }
        if (opBuilder == null) {
            return composite;
        }
        try {
            ModelNode result = client.execute(opBuilder.build());
            if (!Util.isSuccess(result)) {
                throw new CommandFormatException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to add overlay", e);
        }
        return null;
    }

    protected ModelNode link(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        this.assertNotPresent(this.allRelevantServerGroups, args);
        String name = this.getName(ctx, false);
        String[] deployments = this.getLinks(this.deployments, args);
        if (deployments == null) {
            throw new CommandFormatException(this.deployments.getFullName() + " is required.");
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelControllerClient client = ctx.getModelControllerClient();
        if (ctx.isDomainMode()) {
            List<String> sg = this.getServerGroupsToLink(ctx);
            for (String group : sg) {
                if (!Util.isValidPath(client, "server-group", group, "deployment-overlay", name)) {
                    ModelNode op = new ModelNode();
                    ModelNode address = op.get("address");
                    address.add("server-group", group);
                    address.add("deployment-overlay", name);
                    op.get("operation").set(ADD);
                    steps.add(op);
                }
                this.addAddRedeployLinksSteps(ctx, steps, name, group, deployments, false);
            }
        } else {
            this.addAddRedeployLinksSteps(ctx, steps, name, null, deployments, false);
        }
        return composite;
    }

    protected ModelNode upload(CommandContext ctx, boolean stream) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String name = this.getName(ctx, false);
        String contentStr = this.content.getValue(args, true);
        String[] contentPairs = contentStr.split(",+");
        if (contentPairs.length == 0) {
            throw new CommandFormatException("Overlay content is not specified.");
        }
        String[] contentNames = new String[contentPairs.length];
        File[] contentPaths = new File[contentPairs.length];
        for (int i = 0; i < contentPairs.length; ++i) {
            String pair = contentPairs[i];
            int equalsIndex = pair.indexOf(61);
            if (equalsIndex < 0) {
                throw new CommandFormatException("Content pair is not following archive-path=fs-path format: '" + pair + "'");
            }
            contentNames[i] = pair.substring(0, equalsIndex);
            if (contentNames[i].length() == 0) {
                throw new CommandFormatException("The archive path is missing for the content '" + pair + "'");
            }
            String path = pair.substring(equalsIndex + 1);
            if (path.length() == 0) {
                throw new CommandFormatException("The filesystem paths is missing for the content '" + pair + "'");
            }
            File f = new File(path = this.pathCompleter.translatePath(path));
            if (!f.exists()) {
                throw new CommandFormatException("Content file doesn't exist " + f.getAbsolutePath());
            }
            contentPaths[i] = f;
        }
        String deploymentsStr = this.deployments.getValue(args);
        if (deploymentsStr != null) {
            throw new CommandFormatException(this.deployments.getFullName() + " can't be used in combination with upload.");
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        ModelNode composite = new ModelNode();
        OperationBuilder opBuilder = stream ? new OperationBuilder(composite, true) : null;
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (int i = 0; i < contentNames.length; ++i) {
            ModelNode op = new ModelNode();
            ModelNode address = op.get("address");
            address.add("deployment-overlay", name);
            address.add("content", contentNames[i]);
            op.get("operation").set(ADD);
            if (opBuilder != null) {
                op.get("content").get("input-stream-index").set(i);
                opBuilder.addFileAsAttachment(contentPaths[i]);
            } else {
                op.get("content").get("bytes").set(Util.readBytes(contentPaths[i]));
            }
            steps.add(op);
        }
        if (this.redeployAffected.isPresent(args)) {
            this.addRedeployStep(name, steps);
        } else {
            this.printWarning(ctx, client, name, contentStr, null);
        }
        if (opBuilder == null) {
            return composite;
        }
        try {
            ModelNode result = client.execute(opBuilder.build());
            if (!Util.isSuccess(result)) {
                throw new CommandFormatException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to add overlay", e);
        }
        return null;
    }

    protected List<String> loadContentFor(ModelControllerClient client, String overlay) throws CommandLineException {
        ModelNode response;
        ModelNode op = new ModelNode();
        op.get("address").add("deployment-overlay", overlay);
        op.get("operation").set("read-children-names");
        op.get("child-type").set("content");
        try {
            response = client.execute(op);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load the list of the existing content for overlay " + overlay, e);
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("Failed to load the list of the existing content for overlay " + overlay + ": " + response);
        }
        ArrayList<String> contentList = new ArrayList<String>();
        for (ModelNode node : result.asList()) {
            contentList.add(node.asString());
        }
        return contentList;
    }

    protected List<String> loadLinks(ModelControllerClient client, String overlay, String serverGroup) throws CommandLineException {
        ModelNode response;
        ModelNode op = new ModelNode();
        ModelNode addr = op.get("address");
        if (serverGroup != null) {
            addr.add("server-group", serverGroup);
        }
        addr.add("deployment-overlay", overlay);
        op.get("operation").set("read-children-names");
        op.get("child-type").set("deployment");
        try {
            response = client.execute(op);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay, e);
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            String descr = Util.getFailureDescription(response);
            if (descr != null && descr.contains("WFLYCTL0216")) {
                return Collections.emptyList();
            }
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay + ": " + response);
        }
        ArrayList<String> contentList = new ArrayList<String>();
        for (ModelNode node : result.asList()) {
            contentList.add(node.asString());
        }
        return contentList;
    }

    protected ModelNode loadLinkResources(ModelControllerClient client, String overlay, String serverGroup) throws CommandLineException {
        ModelNode response;
        ModelNode op = new ModelNode();
        ModelNode addr = op.get("address");
        if (serverGroup != null) {
            addr.add("server-group", serverGroup);
        }
        addr.add("deployment-overlay", overlay);
        op.get("operation").set("read-children-resources");
        op.get("child-type").set("deployment");
        try {
            response = client.execute(op);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay, e);
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            String descr = Util.getFailureDescription(response);
            if (descr != null && (descr.contains("WFLYCTL0216") || descr.contains("WFLYCTL0202"))) {
                return null;
            }
            throw new CommandLineException("Failed to load the list of deployments for overlay " + overlay + ": " + response);
        }
        return result;
    }

    protected String[] getLinks(ArgumentWithValue linksArg, ParsedCommandLine args) throws CommandFormatException {
        String[] deployments;
        String deploymentsStr = linksArg.getValue(args);
        if (deploymentsStr == null) {
            deployments = null;
        } else {
            deployments = deploymentsStr.split(",+");
            if (deployments.length == 0) {
                throw new CommandFormatException(linksArg.getFullName() + " is missing value.");
            }
        }
        return deployments;
    }

    protected List<String> getServerGroupsToLink(CommandContext ctx) throws CommandFormatException {
        List<String> sg;
        String sgStr = this.serverGroups.getValue(ctx.getParsedCommandLine());
        if (this.allServerGroups.isPresent(ctx.getParsedCommandLine())) {
            if (sgStr != null) {
                throw new CommandFormatException("Only one of " + this.allServerGroups.getFullName() + " or " + this.serverGroups.getFullName() + " can be specified at a time.");
            }
            sg = Util.getServerGroups(ctx.getModelControllerClient());
            if (sg.isEmpty()) {
                throw new CommandFormatException("No server group is available.");
            }
        } else {
            if (sgStr == null) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " or " + this.allServerGroups.getFullName() + " must be specified.");
            }
            sg = Arrays.asList(sgStr.split(",+"));
            if (sg.isEmpty()) {
                throw new CommandFormatException(this.serverGroups.getFullName() + " is missing value.");
            }
        }
        return sg;
    }

    protected void addAddRedeployLinksSteps(CommandContext ctx, ModelNode steps, String overlay, String serverGroup, String[] links, boolean regexp) throws CommandLineException {
        boolean warn = false;
        for (String link : links) {
            ModelNode op = new ModelNode();
            ModelNode address = op.get("address");
            if (serverGroup != null) {
                address.add("server-group", serverGroup);
            }
            address.add("deployment-overlay", overlay);
            address.add("deployment", link);
            op.get("operation").set(ADD);
            steps.add(op);
            if (this.redeployAffected.isPresent(ctx.getParsedCommandLine())) {
                this.addRedeployStep(overlay, link, serverGroup, steps);
                continue;
            }
            warn = true;
        }
        if (warn) {
            String warningMsg = serverGroup == null ? WARN_MSG + Arrays.toString(links) : WARN_MSG + Arrays.toString(links) + " in server group " + serverGroup;
            ctx.printLine(warningMsg);
        }
    }

    protected void assertNotPresent(ArgumentWithoutValue arg, ParsedCommandLine args) throws CommandFormatException {
        if (arg.isPresent(args)) {
            throw new CommandFormatException(arg.getFullName() + " is not allowed with action '" + this.action.getValue(args) + "'");
        }
    }

    protected List<String> filterLinks(ModelNode linkResources) {
        if (linkResources != null && !linkResources.keys().isEmpty()) {
            List links = linkResources.asPropertyList();
            ArrayList<String> linkNames = new ArrayList<String>(links.size());
            for (Property link : links) {
                linkNames.add(link.getName());
            }
            return linkNames;
        }
        return Collections.emptyList();
    }
}

