/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.trycatch;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandLineRedirection;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.controller.client.ModelControllerClient;

class TryCatchFinallyControlFlow
implements CommandLineRedirection {
    private static final String CTX_KEY = "TRY";
    private static final int IN_TRY = 0;
    private static final int IN_CATCH = 1;
    private static final int IN_FINALLY = 2;
    private CommandLineRedirection.Registration registration;
    private final List<String> tryList = new ArrayList<String>();
    private List<String> catchList;
    private List<String> finallyList;
    private int state;

    static TryCatchFinallyControlFlow get(CommandContext ctx) {
        return (TryCatchFinallyControlFlow)ctx.get(CommandContext.Scope.CONTEXT, CTX_KEY);
    }

    TryCatchFinallyControlFlow(CommandContext ctx) {
        ctx.set(CommandContext.Scope.CONTEXT, CTX_KEY, this);
    }

    @Override
    public void set(CommandLineRedirection.Registration registration) {
        this.registration = registration;
    }

    @Override
    public void handle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine line = ctx.getParsedCommandLine();
        if (line.getFormat() == CommandFormat.INSTANCE) {
            if (line.hasProperty("--help") || line.hasProperty("-h")) {
                this.registration.handle(line);
                return;
            }
            String cmd = line.getOperationName();
            if ("catch".equals(cmd) || "finally".equals(cmd) || "end-try".equals(cmd)) {
                this.registration.handle(line);
            } else {
                this.addLine(line.getOriginalLine());
            }
        } else {
            this.addLine(line.getOriginalLine());
        }
    }

    boolean isInTry() {
        return this.state == 0;
    }

    boolean isInFinally() {
        return this.state == 2;
    }

    void moveToCatch() throws CommandLineException {
        switch (this.state) {
            case 0: {
                this.catchList = new ArrayList<String>();
                this.state = 1;
                break;
            }
            case 1: {
                throw new CommandLineException("Already in catch block. Only one catch block is allowed.");
            }
            case 2: {
                throw new CommandLineException("Catch block is not allowed in finally");
            }
            default: {
                throw new IllegalStateException("Unexpected block id: " + this.state);
            }
        }
    }

    void moveToFinally() throws CommandLineException {
        switch (this.state) {
            case 0: 
            case 1: {
                this.finallyList = new ArrayList<String>();
                this.state = 2;
                break;
            }
            case 2: {
                throw new CommandLineException("Already in finally");
            }
            default: {
                throw new IllegalStateException("Unexpected block id: " + this.state);
            }
        }
    }

    private void addLine(String line) {
        switch (this.state) {
            case 0: {
                this.tryList.add(line);
                break;
            }
            case 1: {
                this.catchList.add(line);
                break;
            }
            case 2: {
                this.finallyList.add(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected block id: " + this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(CommandContext ctx) throws CommandLineException {
        if (this.state == 0) {
            throw new CommandLineException("The flow can be executed only after catch or finally.");
        }
        try {
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                throw new CommandLineException("The connection to the controller has not been established.");
            }
            this.registration.unregister();
            CommandLineException error = null;
            if (this.tryList.isEmpty()) {
                throw new CommandLineException("The try block is empty");
            }
            try {
                this.executeBlock(ctx, this.tryList, "try");
            }
            catch (CommandLineException eTry) {
                if (this.catchList == null) {
                    error = eTry;
                }
                try {
                    this.executeBlock(ctx, this.catchList, "catch");
                }
                catch (CommandLineException eCatch) {
                    error = eCatch;
                }
            }
            try {
                this.executeBlock(ctx, this.finallyList, "finally");
            }
            catch (CommandLineException eFinally) {
                if (error != null) {
                    eFinally.addSuppressed(error);
                }
                error = eFinally;
            }
            if (error != null) {
                throw error;
            }
        }
        finally {
            if (this.registration.isActive()) {
                this.registration.unregister();
            }
            ctx.remove(CommandContext.Scope.CONTEXT, CTX_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBlock(CommandContext ctx, List<String> block, String blockName) throws CommandLineException {
        if (block != null && !block.isEmpty()) {
            BatchManager batchManager = ctx.getBatchManager();
            boolean discardActivatedBatch = !batchManager.isBatchActive();
            try {
                for (String l : block) {
                    ctx.handle(l);
                }
            }
            finally {
                if (discardActivatedBatch && batchManager.isBatchActive()) {
                    batchManager.discardActiveBatch();
                }
            }
        }
    }
}

