/*
 * Licensed to the University Corporation for Advanced Internet Development, 
 * Inc. (UCAID) under one or more contributor license agreements.  See the 
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache 
 * License, Version 2.0 (the "License"); you may not use this file except in 
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.soap.wspolicy;

/**
 * WS-Policy 1.2 constants.
 * 
 * @see "WS-Policy (http://schemas.xmlsoap.org/ws/2004/09/policy)"
 * 
 */
public final class WSPolicyConstants {

    /** WS-Policy namespace. */
    public static final String WSP_NS= "http://schemas.xmlsoap.org/ws/2004/09/policy";

    /** WS-Policy namespace prefix. */
    public static final String WSP_PREFIX= "wsp";
    
    /** Constructor. Private to prevent instantiation. */
    private WSPolicyConstants() { }

}
