/* Generated By:JJTree: Do not edit this line. OAndBlock.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OAndBlock extends OBooleanExpression {
  List<OBooleanExpression> subBlocks = new ArrayList<OBooleanExpression>();

  public OAndBlock(int id) {
    super(id);
  }

  public OAndBlock(OrientSql p, int id) {
    super(p, id);
  }

  @Override
  public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {

    if (getSubBlocks() == null) {
      return true;
    }

    for (OBooleanExpression block : subBlocks) {
      if (!block.evaluate(currentRecord, ctx)) {
        return false;
      }
    }
    return true;

  }

  public List<OBooleanExpression> getSubBlocks() {
    return subBlocks;
  }

  public void setSubBlocks(List<OBooleanExpression> subBlocks) {
    this.subBlocks = subBlocks;
  }

  public void toString(Map<Object, Object> params, StringBuilder builder) {
    if (subBlocks == null || subBlocks.size() == 0) {
      return;
    }
    // if (subBlocks.size() == 1) {
    // subBlocks.get(0).toString(params, builder);
    // }

    boolean first = true;
    for (OBooleanExpression expr : subBlocks) {
      if (!first) {
        builder.append(" AND ");
      }
      expr.toString(params, builder);
      first = false;
    }
  }

  @Override
  protected boolean supportsBasicCalculation() {
    for (OBooleanExpression expr : subBlocks) {
      if (!expr.supportsBasicCalculation()) {
        return false;
      }
    }
    return true;
  }

  @Override
  protected int getNumberOfExternalCalculations() {
    int result = 0;
    for (OBooleanExpression expr : subBlocks) {
      result += expr.getNumberOfExternalCalculations();
    }
    return result;
  }

  @Override
  protected List<Object> getExternalCalculationConditions() {
    List<Object> result = new ArrayList<Object>();
    for (OBooleanExpression expr : subBlocks) {
      result.addAll(expr.getExternalCalculationConditions());
    }
    return result;
  }

  public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
    if (subBlocks == null) {
      return null;
    }
    List<OBinaryCondition> result = new ArrayList<OBinaryCondition>();
    for (OBooleanExpression exp : subBlocks) {
      List<OBinaryCondition> sub = exp.getIndexedFunctionConditions(iSchemaClass, database);
      if (sub != null && sub.size() > 0) {
        result.addAll(sub);
      }
    }
    return result.size() == 0 ? null : result;
  }

  public List<OAndBlock> flatten() {
    List<OAndBlock> result = new ArrayList<OAndBlock>();
    boolean first = true;
    for (OBooleanExpression sub : subBlocks) {
      List<OAndBlock> subFlattened = sub.flatten();
      List<OAndBlock> oldResult = result;
      result = new ArrayList<OAndBlock>();
      for (OAndBlock subAndItem : subFlattened) {
        if (first) {
          result.add(subAndItem);
        } else {
          ;
          for(OAndBlock oldResultItem:oldResult) {
            OAndBlock block = new OAndBlock(-1);
            block.subBlocks.addAll(oldResultItem.subBlocks);
            for (OBooleanExpression resultItem : subAndItem.subBlocks) {
              block.subBlocks.add(resultItem);
            }
            result.add(block);
          }
        }
      }
      first = false;
    }
    return result;
  }

  protected OAndBlock encapsulateInAndBlock(OBooleanExpression item) {
    if(item instanceof OAndBlock){
      return (OAndBlock)item;
    }
    OAndBlock result = new OAndBlock(-1);
    result.subBlocks.add(item);
    return result;
  }

}
/* JavaCC - OriginalChecksum=cf1f66cc86cfc93d357f9fcdfa4a4604 (do not edit this line) */
