/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.IntFunction;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;

public class CollectionExternalizer<T extends Collection<Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final IntFunction<T> factory;

    CollectionExternalizer(Class<?> targetClass, IntFunction<T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T collection) throws IOException {
        CollectionExternalizer.writeCollection(output, collection);
    }

    static <T extends Collection<Object>> void writeCollection(ObjectOutput output, T collection) throws IOException {
        IndexExternalizer.VARIABLE.writeData(output, collection.size());
        for (Object element : collection) {
            output.writeObject(element);
        }
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = IndexExternalizer.VARIABLE.readData(input);
        return (T)CollectionExternalizer.readCollection(input, (Collection)this.factory.apply(size), size);
    }

    static <T extends Collection<Object>> T readCollection(ObjectInput input, T collection, int size) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            collection.add((Object)input.readObject());
        }
        return collection;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public static class LinkedListExternalizer
    extends CollectionExternalizer<LinkedList<Object>> {
        public LinkedListExternalizer() {
            super(LinkedList.class, size -> new LinkedList());
        }
    }

    public static class LinkedHashSetExternalizer
    extends CollectionExternalizer<LinkedHashSet<Object>> {
        public LinkedHashSetExternalizer() {
            super(LinkedHashSet.class, LinkedHashSet::new);
        }
    }

    public static class HashSetExternalizer
    extends CollectionExternalizer<HashSet<Object>> {
        public HashSetExternalizer() {
            super(HashSet.class, HashSet::new);
        }
    }

    public static class ConcurrentLinkedQueueExternalizer
    extends CollectionExternalizer<ConcurrentLinkedQueue<Object>> {
        public ConcurrentLinkedQueueExternalizer() {
            super(ConcurrentLinkedQueue.class, size -> new ConcurrentLinkedQueue());
        }
    }

    public static class ConcurrentLinkedDequeExternalizer
    extends CollectionExternalizer<ConcurrentLinkedDeque<Object>> {
        public ConcurrentLinkedDequeExternalizer() {
            super(ConcurrentLinkedDeque.class, size -> new ConcurrentLinkedDeque());
        }
    }

    public static class ConcurrentHashSetExternalizer
    extends CollectionExternalizer<ConcurrentHashMap.KeySetView<Object, Boolean>> {
        public ConcurrentHashSetExternalizer() {
            super(ConcurrentHashMap.KeySetView.class, capacity -> ConcurrentHashMap.newKeySet(capacity));
        }
    }

    public static class ArrayListExternalizer
    extends CollectionExternalizer<ArrayList<Object>> {
        public ArrayListExternalizer() {
            super(ArrayList.class, ArrayList::new);
        }
    }

    public static class ArrayDequeExternalizer
    extends CollectionExternalizer<ArrayDeque<Object>> {
        public ArrayDequeExternalizer() {
            super(ArrayDeque.class, ArrayDeque::new);
        }
    }
}

