/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.baggage;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.uber.jaeger.baggage.BaggageRestrictionManagerProxy;
import com.uber.jaeger.baggage.http.BaggageRestrictionResponse;
import com.uber.jaeger.exceptions.BaggageRestrictionManagerException;
import com.uber.jaeger.utils.Http;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class HttpBaggageRestrictionManagerProxy
implements BaggageRestrictionManagerProxy {
    private static final String DEFAULT_HOST_PORT = "localhost:5778";
    private static final Type LIST_TYPE = new TypeToken<ArrayList<BaggageRestrictionResponse>>(){}.getType();
    private final Gson gson = new Gson();
    private final String hostPort;

    public HttpBaggageRestrictionManagerProxy(String hostPort) {
        this.hostPort = hostPort != null ? hostPort : DEFAULT_HOST_PORT;
    }

    List<BaggageRestrictionResponse> parseJson(String json) throws BaggageRestrictionManagerException {
        try {
            return (List)this.gson.fromJson(json, LIST_TYPE);
        }
        catch (JsonSyntaxException e) {
            throw new BaggageRestrictionManagerException("Cannot deserialize json", e);
        }
    }

    @Override
    public List<BaggageRestrictionResponse> getBaggageRestrictions(String serviceName) throws BaggageRestrictionManagerException {
        String jsonString;
        try {
            jsonString = Http.makeGetRequest("http://" + this.hostPort + "/baggageRestrictions?service=" + URLEncoder.encode(serviceName, "UTF-8"));
        }
        catch (IOException e) {
            throw new BaggageRestrictionManagerException("http call to get baggage restriction from local agent failed.", e);
        }
        return this.parseJson(jsonString);
    }
}

