/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.senders;

import com.uber.jaeger.agent.thrift.Agent;
import com.uber.jaeger.exceptions.SenderException;
import com.uber.jaeger.reporters.protocols.ThriftUdpTransport;
import com.uber.jaeger.senders.ThriftSender;
import com.uber.jaeger.thriftjava.Batch;
import com.uber.jaeger.thriftjava.Process;
import com.uber.jaeger.thriftjava.Span;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public class UdpSender
extends ThriftSender {
    public static final String DEFAULT_AGENT_UDP_HOST = "localhost";
    public static final int DEFAULT_AGENT_UDP_COMPACT_PORT = 6831;
    private Agent.Client agentClient;
    private ThriftUdpTransport udpTransport;

    public UdpSender() {
        this(DEFAULT_AGENT_UDP_HOST, 6831, 0);
    }

    public UdpSender(String host, int port, int maxPacketSize) {
        super((TProtocolFactory)new TCompactProtocol.Factory(), maxPacketSize);
        if (host == null || host.length() == 0) {
            host = DEFAULT_AGENT_UDP_HOST;
        }
        if (port == 0) {
            port = 6831;
        }
        this.udpTransport = ThriftUdpTransport.newThriftUdpClient(host, port);
        this.agentClient = new Agent.Client(this.protocolFactory.getProtocol((TTransport)this.udpTransport));
    }

    @Override
    public void send(Process process, List<Span> spans) throws TException {
        this.agentClient.emitBatch(new Batch(process, spans));
    }

    @Override
    public int close() throws SenderException {
        try {
            int n = super.close();
            return n;
        }
        finally {
            this.udpTransport.close();
        }
    }

    @Override
    public String toString() {
        return "UdpSender(udpTransport=" + this.udpTransport + ")";
    }
}

