/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.ClientSpanThreadBinder;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.InetAddressUtilities;
import com.github.kristofa.brave.InheritableServerClientAndLocalSpanState;
import com.github.kristofa.brave.LocalSpanThreadBinder;
import com.github.kristofa.brave.LocalTracer;
import com.github.kristofa.brave.LoggingReporter;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorReporterAdapter;
import com.github.kristofa.brave.ThreadLocalServerClientAndLocalSpanState;
import com.github.kristofa.brave.TraceFilter;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Endpoint;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import zipkin.Span;
import zipkin.reporter.Reporter;

public class Brave {
    private final ServerTracer serverTracer;
    private final ClientTracer clientTracer;
    private final LocalTracer localTracer;
    private final ServerRequestInterceptor serverRequestInterceptor;
    private final ServerResponseInterceptor serverResponseInterceptor;
    private final ClientRequestInterceptor clientRequestInterceptor;
    private final ClientResponseInterceptor clientResponseInterceptor;
    private final AnnotationSubmitter serverSpanAnnotationSubmitter;
    private final ServerSpanThreadBinder serverSpanThreadBinder;
    private final ClientSpanThreadBinder clientSpanThreadBinder;
    private final LocalSpanThreadBinder localSpanThreadBinder;

    public ClientTracer clientTracer() {
        return this.clientTracer;
    }

    public LocalTracer localTracer() {
        return this.localTracer;
    }

    public ServerTracer serverTracer() {
        return this.serverTracer;
    }

    public ClientRequestInterceptor clientRequestInterceptor() {
        return this.clientRequestInterceptor;
    }

    public ClientResponseInterceptor clientResponseInterceptor() {
        return this.clientResponseInterceptor;
    }

    public ServerRequestInterceptor serverRequestInterceptor() {
        return this.serverRequestInterceptor;
    }

    public ServerResponseInterceptor serverResponseInterceptor() {
        return this.serverResponseInterceptor;
    }

    public ServerSpanThreadBinder serverSpanThreadBinder() {
        return this.serverSpanThreadBinder;
    }

    public ClientSpanThreadBinder clientSpanThreadBinder() {
        return this.clientSpanThreadBinder;
    }

    public LocalSpanThreadBinder localSpanThreadBinder() {
        return this.localSpanThreadBinder;
    }

    public AnnotationSubmitter serverSpanAnnotationSubmitter() {
        return this.serverSpanAnnotationSubmitter;
    }

    private Brave(Builder builder) {
        this.serverTracer = ServerTracer.builder().randomGenerator(builder.random).reporter((Reporter<Span>)builder.reporter).state(builder.state).traceSampler(builder.sampler).clock(builder.clock).build();
        this.clientTracer = ClientTracer.builder().randomGenerator(builder.random).reporter((Reporter<Span>)builder.reporter).state(builder.state).traceSampler(builder.sampler).clock(builder.clock).build();
        this.localTracer = LocalTracer.builder().randomGenerator(builder.random).reporter((Reporter<Span>)builder.reporter).allowNestedLocalSpans(builder.allowNestedLocalSpans).spanAndEndpoint(SpanAndEndpoint.LocalSpanAndEndpoint.create(builder.state)).traceSampler(builder.sampler).clock(builder.clock).build();
        this.serverRequestInterceptor = new ServerRequestInterceptor(this.serverTracer);
        this.serverResponseInterceptor = new ServerResponseInterceptor(this.serverTracer);
        this.clientRequestInterceptor = new ClientRequestInterceptor(this.clientTracer);
        this.clientResponseInterceptor = new ClientResponseInterceptor(this.clientTracer);
        this.serverSpanAnnotationSubmitter = AnnotationSubmitter.create(SpanAndEndpoint.ServerSpanAndEndpoint.create(builder.state));
        this.serverSpanThreadBinder = new ServerSpanThreadBinder(builder.state);
        this.clientSpanThreadBinder = new ClientSpanThreadBinder(builder.state);
        this.localSpanThreadBinder = new LocalSpanThreadBinder(builder.state);
    }

    public static class Builder {
        private final ServerClientAndLocalSpanState state;
        private Reporter reporter = new LoggingReporter();
        private Random random = new Random();
        private Sampler sampler = Sampler.create(1.0f);
        private boolean allowNestedLocalSpans = false;
        private AnnotationSubmitter.Clock clock = AnnotationSubmitter.DefaultClock.INSTANCE;

        public Builder() {
            this("unknown");
        }

        public Builder(String serviceName) {
            try {
                int ip = InetAddressUtilities.toInt(InetAddressUtilities.getLocalHostLANAddress());
                this.state = new ThreadLocalServerClientAndLocalSpanState(ip, 0, serviceName);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to get Inet address", e);
            }
        }

        public Builder(int ip, int port, String serviceName) {
            this.state = new ThreadLocalServerClientAndLocalSpanState(ip, port, serviceName);
        }

        public Builder(Endpoint endpoint) {
            this.state = new ThreadLocalServerClientAndLocalSpanState(endpoint);
        }

        public Builder(ServerClientAndLocalSpanState state) {
            this.state = Util.checkNotNull(state, "state must be specified.", new Object[0]);
            this.allowNestedLocalSpans = state instanceof InheritableServerClientAndLocalSpanState;
        }

        @Deprecated
        public Builder traceFilters(List<TraceFilter> ignored) {
            return this;
        }

        public Builder traceSampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public Builder reporter(Reporter<Span> reporter) {
            this.reporter = (Reporter)zipkin.internal.Util.checkNotNull(reporter, (String)"reporter");
            return this;
        }

        @Deprecated
        public Builder spanCollector(SpanCollector spanCollector) {
            this.reporter = new SpanCollectorReporterAdapter(spanCollector);
            return this;
        }

        public Builder clock(AnnotationSubmitter.Clock clock) {
            this.clock = clock;
            return this;
        }

        public Brave build() {
            return new Brave(this);
        }
    }
}

