/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Map;

public class OCommandExecutorSQLDropUser
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_USER = "USER";
    private static final String SYNTAX = "DROP USER <user-name>";
    private static final String USER_CLASS = "OUser";
    private static final String USER_FIELD_NAME = "name";
    private String userName;

    public OCommandExecutorSQLDropUser parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword(KEYWORD_DROP);
        this.parserRequiredKeyword(KEYWORD_USER);
        this.userName = this.parserRequiredWord(false, "Expected <user name>");
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.userName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(USER_CLASS);
        sb.append(" WHERE ");
        sb.append(USER_FIELD_NAME);
        sb.append("='");
        sb.append(this.userName);
        sb.append("'");
        return OCommandExecutorSQLDropUser.getDatabase().command(new OCommandSQL(sb.toString())).execute(new Object[0]);
    }

    @Override
    public String getSyntax() {
        return SYNTAX;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

